/* functions */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <unistd.h>
#include <sys/types.h>
#include <netinet/in.h>

#include "bbtcp.h"
#include "libskelgto.h"
#include "cmdsdgto2func.h"
#include "cmdsdgto2.h"

extern COMMAND comlist[];

char data[64] = {0};
const char *ofstr[] = {"off\0", "on\0"};

char *findparam(char ena, SDGTOADV *adv){
  int i = 0;

  while(adv[i].param){
    if(ena == adv[i].enable){
      return adv[i].param;
    }
    i++;
  }
  
  return NULL;
}

int finderr(char c, SDGTOERROR *err, SDGTOERROR *rerr){
  int i=0;
  while(err[i].code){
    if(c == err[i].code){
      memcpy((char *)rerr, (char *)(err+i), sizeof(SDGTOERROR));
      if(err[i].type == NONE){
	return 0;
      }else{
	return 1;
      }
    }
    i++;
  }
  return 0;
}

int chkupper(char c){
  if(isupper(c)){
    return 1;
  }else{
    return 0;
  }
}

int chkone(char c){
  if(c == '1'){
    return 1;
  }
  return 0;
}

char chkval(char *arg, SDGTOADV *adv){
  int i=0;
  while(adv[i].param){
    if(!strcmp(adv[i].param, arg)){
      return adv[i].enable;
    }
    i++;
  }

  return -1;
}

char chkadv(char *arg, SDGTOADV *adv, SDGTOADV *radv){
  int i=0;
  while(adv[i].param){
    if(!strcmp(adv[i].param, arg)){
      memcpy((char *)radv, (char *)(adv+i), sizeof(SDGTOADV));
      return 1;
    }
    i++;
  }
  radv->param = NULL;
  radv->addr = -1;
  radv->enable = -1;
  radv->disable = -1;
  return -1;
}

int noop(void){
  return gto_uread(adr_status, data);
}

int status(void){
  int i;
  SDGTOERROR rerr;
  
  gto_uread(adr_status, data);

  printf("Version    : ");
  for(i=0;i<4;i++){
    printf("%c", data[i]);
  }
  printf("\n");
  printf("Monitor 0  : %s\n", findparam(data[i], chadv)); i++;
  printf("Monitor 1  : %s\n", findparam(data[i], chadv)); i++;
  for(i=6;i<10;i++){
    printf("Trigger %d  : %s\n", i-6, ofstr[chkupper(data[i])]);
  }
  for(i=10;i<30;i++){
    printf("Busy %2d    : %-3s", i-10, ofstr[chkupper(data[i])]);
    if(chkupper(data[i+20])){
      printf(" *BUSY");
    }
    printf("\n");
  }
  printf("Test LED   : %s\n", ofstr[chkupper(data[50])]);
  printf("Output 2   : %s\n", findparam(data[51], out2adv));
  printf("Output 3   : %s\n", findparam(data[52], out3adv));
  printf("Exception  : %s\n", ofstr[chkone(data[61])]);
  printf("Error code : %c ", data[62]);
  if(finderr(data[62], err, &rerr)){
    printf("  *%s %s\n", errtype[rerr.type], rerr.param);
  }else{
    printf("\n");
  }
  printf("DAQ Start  : %s\n", ofstr[chkupper(data[63])]);

  return 1;
}

int error(void){
  SDGTOERROR rerr;

  gto_uread(adr_status, data);

  if(finderr(data[62], err, &rerr)){
    printf("GTOERROR %s %s\n", errtype[rerr.type], rerr.param);
  }else{
    printf("\n");
  }

  return 1;
}

int uread(void){
  gto_uread(adr_status, data);
  //gto_read(data);
  gto_dumpdata(data);
  gto_dumpcdata(data);
  return 1;
}

int scaler(void){
  unsigned int val, i;
  unsigned short sval;
  
  gto_uread(adr_scaler, data);

  for(i=0;i<3;i++){
    memcpy((char *)&val, data+i*4, sizeof(val));
    if(i==0){
      printf("%-9s", "Gated");
    }
    if(i==1){
      printf("%-9s", "Ungated");
    }
    if(i==2){
      printf("%-9s", "1k Clock");
    }

    printf(" : %d\n", val);
  }

  for(i=0;i<20;i++){
    memcpy((char *)&sval, data+12+i*2, sizeof(sval));
    printf("%s%2d     : %d\n", "EOB", i, sval);
  }


  return 1;
}


int babiscr(char *args[]){
  unsigned int val, i, scr[24];
  unsigned short sval;
  int sock;
  char buff[128] = {0};
  int t, len = 120;
  time_t tt;
  
  if(!args[0]) return 0;

  // efn and sclaer id = 1 fixed

  gto_uread(adr_scaler, data);

  for(i=0;i<3;i++){
    memcpy((char *)&val, data+i*4, sizeof(val));
    scr[i] = val;
  }

  scr[3] = 0;

  for(i=0;i<20;i++){
    memcpy((char *)&sval, data+12+i*2, sizeof(sval));
    scr[i+4] = (unsigned int)sval;
  }


  t = 0x0000003c; // hd1 ly=0,cid=0,size=60
  memcpy(buff, (char *)&t, 4);

  t = 1;  // hd2 efn = 1
  memcpy(buff+4, (char *)&t, 4);

  t = 0x13400038;  // scrhd ly=1,cid=13,size=56
  memcpy(buff+8, (char *)&t, 4);

  t = 1;  // scrhd2 efn = 1
  memcpy(buff+12, (char *)&t, 4);

  time(&tt);
  t = (int)tt; // scrhd3 date
  memcpy(buff+16, (char *)&t, 4);

  t = 1;  // scrhd4 scrid = 1
  memcpy(buff+20, (char *)&t, 4);
  
  memcpy(buff+24, (char *)scr, sizeof(scr));

  if((sock = mktcpsend_tout(args[0], 17513, 3)) == 0){
    printf("Cannot connect to babild=%s\n", args[0]);
    return 0;
  }

  send(sock, (char *)&len, 4, 0);
  send(sock, (char *)buff, len, 0);
  
  close(sock);
  return 1;
}


int init(void){
  printf("Initialize\n");
  return gto_reset();
}

int eepr(void){
  printf("Parameters from EEPROM\n");
  gto_eepread();

  gto_read(data);
  gto_dumpdata(data);
  gto_dumpcdata(data);
  return 1;
}

int eepw(void){
  printf("Current parameters to EEPROM\n");
  return gto_eepwrite();
}

int mon0(char *args[]){
  char v;

  if(!args[0]) return 0;

  if((v = chkval(args[0], chadv)) < 0){
    printf("Invalid channel name %s\n", args[0]);
    return 0;
  }

  gto_write(adr_mon0, v);
  printf("Set Monitor1 %s\n", args[0]);

  return 1;
}

int mon1(char *args[]){
  char v;

  if(!args[0]) return 0;

  if((v = chkval(args[0], chadv)) < 0){
    printf("Invalid channel name %s\n", args[0]);
    return 0;
  }

  gto_write(adr_mon1, v);
  printf("Set Monitor1 %s\n", args[0]);

  return 1;
}

int enable(char *args[]){
  int i=0;
  SDGTOADV adv;
  while(args[i]){
    chkadv(args[i], chadv, &adv);
    if(adv.addr > -1){
      gto_write(adv.addr, adv.enable);
      printf("enable %s\n", adv.param);
      //printf("%s %d %c %c\n", adv.param, adv.addr, adv.enable, adv.disable);
    }else{
      printf("Invalid channel name %s\n", args[i]);
    }
    i++;
  }

  return 1;
}

int disable(char *args[]){
  int i=0;
  SDGTOADV adv;
  while(args[i]){
    chkadv(args[i], chadv, &adv);
    if(adv.addr > -1){
      gto_write(adv.addr, adv.disable);
      printf("disable %s\n", adv.param);
      //printf("%s %d %c %c\n", adv.param, adv.addr, adv.enable, adv.disable);
    }else{
      printf("Invalid channel name %s\n", args[i]);
    }
    i++;
  }

  return 1;
}

int out2(char *args[]){
  char v;

  if(!args[0]) return 0;

  if((v = chkval(args[0], out2adv)) > -1){
    gto_write(adr_out2, v);
  }else{
    return 0;
  }

  printf("Output2=%s\n", args[0]);

  return 1;
}

int out3(char *args[]){
  char v;

  if(!args[0]) return 0;

  if((v = chkval(args[0], out3adv)) > -1){
    gto_write(adr_out3, v);
  }else{
    return 0;
  }

  printf("Output3=%s\n", args[0]);

  return 1;
}

int pulse(void){
  gto_uwrite(adr_pulse, 1);
  return 1;
}

int exception(char *args[]){
  char v;

  if(!args[0]) return 0;

  if((v = chkval(args[0], exceptionadv)) < 0){
    return 0;
  }
  gto_write(adr_exception, v);

  printf("Exception control %s\n", args[0]);

  return 1;
}

int test(char *args[]){
  char v;

  if(!args[0]) return 0;

  if((v = chkval(args[0], testadv)) < 0){
    return 0;
  }
  gto_write(adr_test, v);

  printf("Test LED %s\n", args[0]);

  return 1;
}

int start(void){
  printf("DAQ Start\n");
  return gto_uwrite(adr_start, val_start);

}

int stop(void){
  printf("DAQ Stop\n");
  return gto_uwrite(adr_stop, val_stop);
}

int help(void){
  int i;
  printf(" cmdsdgto2 HOSTNAME COM [params] ...\n\n");
  printf(" COM = ");
  i = 0;
  while(comlist[i].com != NULL){
    printf(" %-8s : %s ", comlist[i].com, comlist[i].doc);
    if(comlist[i].param != NULL){
      printf("(%s)", comlist[i].param);
    }
    printf("\n       ");
    i++;
  }
  printf("\n");

  return 1;
}
