/* Parameters of SDGTO2 */

const char adr_status    = 0;
const char adr_scaler    = 1;
const char adr_mon0      = 4;
const char adr_mon1      = 5;
const char adr_test      = 50;
const char adr_out2      = 51;
const char adr_out3      = 52;
const char adr_pulse     = 52;
const char adr_exception = 61;
const char adr_start     = 63;
const char adr_stop      = 63;
const char val_start     = 'Z';
const char val_stop      = 'z';


enum errenum {NONE=0, UEEOB=1};
const char *errtype[] = {
  "", //NONE
  "Unexpected EOB", //UEEOB
  NULL
};

typedef struct {
  char code;
  enum errenum type;
  char *param;
} SDGTOERROR;

SDGTOERROR err[] = {
  {'0', NONE,  NULL},
  {'E', UEEOB, "busy0"},
  {'F', UEEOB, "busy1"},
  {'G', UEEOB, "busy2"},
  {'H', UEEOB, "busy3"},
  {'I', UEEOB, "busy4"},
  {'J', UEEOB, "busy5"},
  {'K', UEEOB, "busy6"},
  {'L', UEEOB, "busy7"},
  {'M', UEEOB, "busy8"},
  {'N', UEEOB, "busy9"},
  {'O', UEEOB, "busy10"},
  {'P', UEEOB, "busy11"},
  {'Q', UEEOB, "busy12"},
  {'R', UEEOB, "busy13"},
  {'S', UEEOB, "busy14"},
  {'T', UEEOB, "busy15"},
  {'U', UEEOB, "busy16"},
  {'V', UEEOB, "busy17"},
  {'W', UEEOB, "busy18"},
  {'X', UEEOB, "busy19"},
  {0, NONE, NULL}
};

typedef struct {
  char *param;
  char  addr;
  char  enable;
  char  disable;
} SDGTOADV;

SDGTOADV chadv[] = {
  {"trg0", 6, 'A', 'a'},
  {"trg1", 7, 'B', 'b'},
  {"trg2", 8, 'C', 'c'},
  {"trg3", 9, 'D', 'd'},
  {"busy0", 10, 'E', 'e'},
  {"busy1", 11, 'F', 'f'},
  {"busy2", 12, 'G', 'g'},
  {"busy3", 13, 'H', 'h'},
  {"busy4", 14, 'I', 'i'},
  {"busy5", 15, 'J', 'j'},
  {"busy6", 16, 'K', 'k'},
  {"busy7", 17, 'L', 'l'},
  {"busy8", 18, 'M', 'm'},
  {"busy9", 19, 'N', 'n'},
  {"busy10", 20, 'O', 'o'},
  {"busy11", 21, 'P', 'p'},
  {"busy12", 22, 'Q', 'q'},
  {"busy13", 23, 'R', 'r'},
  {"busy14", 24, 'S', 's'},
  {"busy15", 25, 'T', 't'},
  {"busy16", 26, 'U', 'u'},
  {"busy17", 27, 'V', 'v'},
  {"busy18", 28, 'W', 'w'},
  {"busy19", 29, 'X', 'x'},
  {"trgor", -1, 'Y', -1},
  {"veto",  -1, 'Z', -1},
  {NULL, -1, -1, -1}
};


SDGTOADV testadv[] = {
  {"on",  -1, 'Y', -1},
  {"off", -1, 'y', -1},
  {NULL, -1, -1, -1}
};

SDGTOADV out2adv[] = {
  {"veto", -1, '0', -1},
  {"eob",  -1, '1', -1},
  {NULL, -1, -1, -1}
};

SDGTOADV out3adv[] = {
  {"through", -1, '0', -1},
  {"pulse",   -1, '1', -1},
  {NULL, -1, -1, -1}
};

SDGTOADV exceptionadv[] = {
  {"on",  -1, '1', -1},
  {"off", -1, '0', -1},
  {NULL, -1, -1, -1}
};
