/*
 * last modified : 15/02/03 18:31:16 
 *
 * Hidetada Baba (RIKEN)
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "libskelgto.h"
#include "cmdsdgto2func.h"

COMMAND comlist[] = {
  {"status",    status,    "Read status", NULL},
  {"error",     error,     "Report error", NULL},
  {"read",      uread,     "Read parameters (for debug)", NULL},
  {"scaler",    scaler,    "Read builtin Scaler", NULL},
  {"babiscr",   babiscr,   "Send builtin Scaler to babild", "HOSTNAME"},
  {"init",      init,      "Initialize all parameters to default value", NULL},
  {"eepr",      eepr,      "Load parameters from EEPROM", NULL},
  {"eepw",      eepw,      "Save current parameters to EEPROM", NULL},
  {"mon0",      mon0,      "Change Monitr0 channel", "trg0-3, busy0-19, trgor, veto"},
  {"mon1",      mon1,      "Change Monitr1 channel", "trg0-3, busy0-19, trgor, veto"},
  {"enable",    enable,    "Enable trigger/busy inputs", "[trg0-3] [busy0-10]..."},
  {"disable",   disable,   "Disable trigger/busy inputs" "[trg0-3] [busy0-10]..."},
  {"out2",      out2,      "Change Output2 signal", "veto/eob"},
  {"out3",      out3,      "Change Otuput3 signal", "through/pulse"},
  {"pulse",     pulse,     "Single pulse from output3", NULL},
  {"exception", exception, "Exception control", "on/off"},
  {"test",      test,      "Test LED", "on/off"},
  {"start",     start,     "DAQ Start", NULL},
  {"stop",      stop,      "DAQ Stop", NULL},
  {"noop",      noop,      "Dummy access to GTO", NULL},
  {"help",      help,      "Help", NULL},
  {NULL,        NULL,      NULL,   NULL} };

void quit(void){
  gto_close();
}

int main(int argc, char *argv[]){
  int i;

  if(argc < 3){
    help();
    return 0;
  }

  if(!gto_open(argv[1])){
    printf("Cannot connect %s\n", argv[1]);
    return 0;
  }

  gto_flush();

  i=0;
  while(comlist[i].com != NULL){
    if(!strcmp(comlist[i].com, argv[2])){
      if(!comlist[i].func(argv+3)){
	printf("Invalid argument %s\n\n", argv[3]);
	help();
      }
      break;
    }
    i++;
  }

  if(comlist[i].com == NULL){
    printf("Invalid function %s\n\n", argv[2]);
    help();
  }else{
    noop();
  }

  quit();

  return 0;
}
