/* last modified : 13/11/27 16:03:10 
 *
 * gto/gscrgto/libgscrgto.c
 *
 * library for Gated Scaler GTO
 *
 * H.B. (2013)
 *
 */

#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>

#include "bbtcp.h"
#include "libgscrgto.h"

#define PORT_GTO        10001

static int sock = 0;

int gscr_open(char *hostname){
  if(sock) return sock;
  if((sock = mktcpsend(hostname, PORT_GTO)) == 0){
    return 0;
  }
  return sock;
}

void gscr_close(void){
  if(sock) close(sock);
  sock = 0;
}

int gscr_version(char *ver){
  char c[4] = "!!@@";

  if(!sock) return 0;
  send(sock, c, sizeof(c), 0);
  return recv(sock, ver, GSCRGTO_SIZEOF_VERSION, MSG_WAITALL);
}

int gscr_data(char *data){
  char c[4] = "!!R0";

  if(!sock) return 0;
  send(sock, c, sizeof(c), 0);
  return recv(sock, data, GSCRGTO_SIZEOF_DATA, MSG_WAITALL);
}

int gscr_conv(char *data, struct stgscrdata *gscr){
  unsigned int val, i;

  for(i=0;i<GSCRGTO_SIZEOF_DATA/4;i++){
    memcpy((char *)&val, data+i*4, 4);
    switch(i){
    case 0:
      if((val & 0xc0000000) != 0x80000000){
	return 0;
      }
      gscr->gateena = (val & 0x10000000) ? 1 : 0;
      gscr->softveto = (val & 0x20000000) ? 1 : 0;
      gscr->gatenum = val & 0x0fffffff;
      break;
    case 21:
      break;
    case 22:
      gscr->veto  = (val & 0x40000000) ? 1 : 0;
      gscr->level = (val & 0x80000000) ? 1 : 0;
      gscr->gcnt1k = val & 0x3fffffff;
      break;
    case 23:
      gscr->cnt1k = val & 0x3fffffff;
      break;
    default:
      gscr->scr[i-1] = val;
      break;
    }
  }

  return 1;
}

int gscr_command(char tc){
  char c[4] = "!!00";
  c[3] = tc;

  if(!sock) return 0;
  send(sock, c, sizeof(c), 0);
  return 1;
}

void gscr_gateena(int of){
  char tc = 'G';
  if(!of) tc = 'g';
  gscr_command(tc);
}
    
void gscr_softveto(int of){
  char tc = 'V';
  if(!of) tc = 'v';
  gscr_command(tc);
}

void gscr_testled(int of){
  char tc = 'T';
  if(!of) tc = 't';
  gscr_command(tc);
}

void gscr_level(int of){
  char tc = 'L';
  if(!of) tc = 'l';
  gscr_command(tc);
}

void gscr_pulse(void){
  gscr_command('P');
}

void gscr_clear(void){
  gscr_command('C');
}

void gscr_init(void){
  gscr_command('I');
}

int gscr_id(char id[2]){
  char c[6] = "!!1 2 ";
  c[3] = id[0];
  c[5] = id[1];

  if(!sock) return 0;
  send(sock, c, sizeof(c), 0);
  return 1;
}
