/* functions */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

#include "libskelgto.h"
#include "cmdgdgtofunc.h"
#include "cmdgdgto.h"

extern COMMAND comlist[];

char data[64] = {0};
char t[256] = {0};

const char *ofstr[] = {"off\0", "on\0"};
const char *modestr[] = {"GD\0", "CLKGD\0", "Clk\0", "1K Clk\0", "None\0"};
struct stchinfo chinfo[4];

char *findparam(char ena, SDGTOADV *adv){
  int i = 0;

  while(adv[i].param){
    if(ena == adv[i].enable){
      return adv[i].param;
    }
    i++;
  }
  
  return NULL;
}

int chkupper(char c){
  if(isupper(c)){
    return 1;
  }else{
    return 0;
  }
}

int chkone(char c){
  if(c == '1'){
    return 1;
  }
  return 0;
}

char chkval(char *arg, SDGTOADV *adv){
  int i=0;
  while(adv[i].param){
    if(!strcmp(adv[i].param, arg)){
      return adv[i].enable;
    }
    i++;
  }

  return -1;
}

char chkadv(char *arg, SDGTOADV *adv, SDGTOADV *radv){
  int i=0;
  while(adv[i].param){
    if(!strcmp(adv[i].param, arg)){
      memcpy((char *)radv, (char *)(adv+i), sizeof(SDGTOADV));
      return 1;
    }
    i++;
  }
  radv->param = NULL;
  radv->addr = -1;
  radv->enable = -1;
  radv->disable = -1;
  return -1;
}

int noop(void){
  return gto_read(data);
}

int convdata(void){
  int i, k;
  gto_read(data);
  unsigned char udata[64];

  memcpy((char *)udata, data, sizeof(data));

  for(i=0;i<4;i++){
    chinfo[i].ch     = i;

    k = i*2;
    chinfo[i].dlc    = ((udata[k+1] << 8) | udata[k]) & 0xffff;

    k = (i+4)*2;
    chinfo[i].wdc    = ((udata[k+1] << 8) | udata[k]) & 0xffff;

    chinfo[i].dlf    = udata[i+16] & 0x1f;
    chinfo[i].wdf    = udata[i+20] & 0x1f;

    k = (i+8)*3;
    chinfo[i].clkdl  = ((udata[k+2] << 16) | (udata[k+1] << 8) | udata[k]) & 0xffffff;
    //printf("%d %d %d\n", udata[k+2], udata[k+1], udata[k]);

    k = (i+12)*3;
    chinfo[i].clkwd  = ((udata[k+2] << 16) | (udata[k+1] << 8) | (unsigned char)udata[k]) & 0xffffff;
    //printf("%d %d %d\n", i, chinfo[i].clkwd, udata[k]);

    chinfo[i].clkdiv = udata[i+48] & 0xff;

    chinfo[i].outsel = udata[i+56] & 0x0f;

    // Calculate
    chinfo[i].gddl   = 10. + (float)chinfo[i].dlc * 40. + (float)chinfo[i].dlf * 1.25;
    chinfo[i].gdwd   = 10. + (float)chinfo[i].wdc * 40. + (float)chinfo[i].wdf * 1.25;

    chinfo[i].clkstep = 40. * chinfo[i].clkdiv;
    if(chinfo[i].clkstep < 20.){
      chinfo[i].clkstep = 20.;
    }      
    chinfo[i].clkgddl = chinfo[i].clkstep * (float)chinfo[i].clkdl;
    chinfo[i].clkgdwd = chinfo[i].clkstep * (float)chinfo[i].clkwd;

    // Correction
    if(chinfo[i].gddl < 50.){
      chinfo[i].gddl = 50.;
    }
    if(chinfo[i].gdwd < 50.){
      chinfo[i].gdwd = 50.;
    }

    if(chinfo[i].dlc == 0 && chinfo[i].dlf == 0){
      chinfo[i].gddl = 20.; // min delay = 20ns
      chinfo[i].gdwd += 30.;
    }

    if(chinfo[i].clkgddl < 20.){
      chinfo[i].clkgddl = 20.;
    }
    if(chinfo[i].clkgdwd < 20.){
      chinfo[i].clkgdwd = 20.;
    }

  }


  return 1;
}

char *calctime(float fv){
  if(fv < 1000.){
    sprintf(t, "%3.0fns", fv);
  }else if(fv < 10000.){
    sprintf(t, "%3.1fus", fv/1000.);
  }else if(fv/1000. < 1000.){
    sprintf(t, "%3.0fus", fv/1000.);
  }else if(fv/1000./1000. < 1000.){
    sprintf(t, "%3.1fms", fv/1000./1000.);
  }else{
    sprintf(t, "%3.1fs", fv/1000./1000./1000.);
  }

  return t;
}

void mininfo(void){
  int i;

  printf("Channel Delay Width\n");
  for(i=0;i<4;i++){
    switch(chinfo[i].outsel){
    case 0:
      printf("   %d    %s", i, calctime(chinfo[i].gddl));
      printf(" %s\n",  calctime(chinfo[i].gdwd));
      break;
    case 1:
      printf("   %d    %s", i, calctime(chinfo[i].clkgddl));
      printf(" %s\n", calctime(chinfo[i].clkgdwd));
      break;
    case 2:
      printf("   %d    Clock %s\n", i, calctime(chinfo[i].clkstep));
      break;
    case 3:
      printf("   %d    1kHz pulse clock\n", i);
      break;
    default:
      printf("   %d    None\n", i);
      break;
    }
  }
}

int status(void){
  int i;

  convdata();
  mininfo();

  printf("\n\n");

  for(i=0;i<4;i++){
    printf("Channel %d  (mode = %s)\n", i, modestr[chinfo[i].outsel]);
    printf(" GD    Delay=%s (CG=%3d, FG=%2d)\n",
	   calctime(chinfo[i].gddl), chinfo[i].dlc, chinfo[i].dlf);
    printf("       Width=%s (CG=%3d, FG=%2d)\n", 
	   calctime(chinfo[i].gdwd), chinfo[i].wdc, chinfo[i].wdf);
    printf(" CLKGD Delay=%s (%6d)\n", calctime(chinfo[i].clkgddl), chinfo[i].clkdl);
    printf("       Width=%s (%6d)\n", calctime(chinfo[i].clkgdwd), chinfo[i].clkwd);
    printf("       Step =%s (%6d)\n", calctime(chinfo[i].clkstep), chinfo[i].clkdiv);

    printf("\n");
  }


  return 1;
}

int read(void){
  gto_read(data);
  gto_dumpdata(data);
  //gto_dumpcdata(data);
  return 1;
}

int init(void){
  printf("Initialize\n");
  return gto_reset();
}

int eepr(void){
  printf("Parameters from EEPROM\n");
  gto_eepread();

  gto_read(data);
  gto_dumpdata(data);
  //gto_dumpcdata(data);
  return 1;
}

int eepw(void){
  printf("Current parameters to EEPROM\n");
  return gto_eepwrite();
}

// Set output source
int out(char adr, char *args[]){
  char v;

  if(!args[0]) return 0;

  if((v = chkval(args[0], outadv)) > -1){
    gto_write(adr, v);
  }else{
    return 0;
  }

  printf("Output=%s\n", args[0]);

  convdata();
  mininfo();

  return 1;
}

int out0(char *args[]){
  return out(adr_out0, args);
}

int out1(char *args[]){
  return out(adr_out1, args);
}

int out2(char *args[]){
  return out(adr_out2, args);
}

int out3(char *args[]){
  return out(adr_out3, args);
}


// set course gain
int cg(char adr, char *args[]){
  unsigned short val;

  if(!args[0]) return 0;

  val = strtol(args[0], NULL, 0);
  
  gto_write16(adr, (short)val);
  convdata();
  mininfo();

  return 1;
}

int dlc0(char *args[]){
  return cg(adr_dlc0, args);
}
int dlc1(char *args[]){
  return cg(adr_dlc1, args);
}
int dlc2(char *args[]){
  return cg(adr_dlc2, args);
}
int dlc3(char *args[]){
  return cg(adr_dlc3, args);
}
int wdc0(char *args[]){
  return cg(adr_wdc0, args);
}
int wdc1(char *args[]){
  return cg(adr_wdc1, args);
}
int wdc2(char *args[]){
  return cg(adr_wdc2, args);
}
int wdc3(char *args[]){
  return cg(adr_wdc3, args);
}

// set course gain
int fg(char adr, char *args[]){
  unsigned char val;

  if(!args[0]) return 0;

  val = strtol(args[0], NULL, 0);
  
  gto_write(adr, (char)val);
  convdata();
  mininfo();

  return 1;
}

int dlf0(char *args[]){
  return fg(adr_dlf0, args);
}
int dlf1(char *args[]){
  return fg(adr_dlf1, args);
}
int dlf2(char *args[]){
  return fg(adr_dlf2, args);
}
int dlf3(char *args[]){
  return fg(adr_dlf3, args);
}
int wdf0(char *args[]){
  return fg(adr_wdf0, args);
}
int wdf1(char *args[]){
  return fg(adr_wdf1, args);
}
int wdf2(char *args[]){
  return fg(adr_wdf2, args);
}
int wdf3(char *args[]){
  return fg(adr_wdf3, args);
}


// set course gain
int clkw(char adr, char *args[]){
  unsigned int val;

  if(!args[0]) return 0;

  val = strtol(args[0], NULL, 0);
  
  gto_write24(adr, (int)val);
  rst(); //to reset the counter value
  convdata();
  mininfo();

  return 1;
}

int clkdl0(char *args[]){
  return clkw(adr_clkdl0, args);
}
int clkdl1(char *args[]){
  return clkw(adr_clkdl1, args);
}
int clkdl2(char *args[]){
  return clkw(adr_clkdl2, args);
}
int clkdl3(char *args[]){
  return clkw(adr_clkdl3, args);
}
int clkwd0(char *args[]){
  return clkw(adr_clkwd0, args);
}
int clkwd1(char *args[]){
  return clkw(adr_clkwd1, args);
}
int clkwd2(char *args[]){
  return clkw(adr_clkwd2, args);
}
int clkwd3(char *args[]){
  return clkw(adr_clkwd3, args);
}

// set course gain
int clkdiv(char adr, char *args[]){
  unsigned int val;

  if(!args[0]) return 0;

  val = strtol(args[0], NULL, 0);
  gto_write16(adr, (int)val);
  rst(); //to reset the counter value
  convdata();
  mininfo();

  return 1;
}

int clkdiv0(char *args[]){
  return clkdiv(adr_clkdiv0, args);
}
int clkdiv1(char *args[]){
  return clkdiv(adr_clkdiv1, args);
}
int clkdiv2(char *args[]){
  return clkdiv(adr_clkdiv2, args);
}
int clkdiv3(char *args[]){
  return clkdiv(adr_clkdiv3, args);
}


int pulse(char *args[]){
  unsigned char val;

  if(!args[0]) return 0;

  val = (unsigned char)strtol(args[0], NULL, 0);
  
  gto_uwrite(adr_pulse, val);

  return 1;
}

int level(char *args[]){
  unsigned char val;

  if(!args[0]) return 0;

  val = (unsigned char)strtol(args[0], NULL, 0);
  
  gto_uwrite(adr_level, val);

  return 1;
}


int rst(void){
  gto_uwrite(adr_rst, 1);
  return 1;
}

int test(char *args[]){
  char v;

  if(!args[0]) return 0;

  if((v = chkval(args[0], testadv)) < 0){
    return 0;
  }
  gto_write(adr_test, v);

  printf("Test LED %s\n", args[0]);

  return 1;
}

int help(void){
  int i;
  printf(" *** for firmware version %s ***\n\n", version);
  printf(" cmdsdgto2 HOSTNAME COM [params] ...\n\n");
  printf(" COM = ");
  i = 0;
  while(comlist[i].com != NULL){
    printf(" %-8s : %s ", comlist[i].com, comlist[i].doc);
    if(comlist[i].param != NULL){
      printf("(%s)", comlist[i].param);
    }
    printf("\n       ");
    i++;
  }
  printf("\n");

  return 1;
}
