/* Parameters of SDGTO2 */

const char version[] = "1.3";

const char adr_dlc0      =  0;
const char adr_dlc1      =  2;
const char adr_dlc2      =  4;
const char adr_dlc3      =  6;
const char adr_wdc0      =  8;
const char adr_wdc1      = 10;
const char adr_wdc2      = 12;
const char adr_wdc3      = 14;
const char adr_dlf0      = 16;
const char adr_dlf1      = 17;
const char adr_dlf2      = 18;
const char adr_dlf3      = 19;
const char adr_wdf0      = 20;
const char adr_wdf1      = 21;
const char adr_wdf2      = 22;
const char adr_wdf3      = 23;
const char adr_clkdl0    = 24;
const char adr_clkdl1    = 27;
const char adr_clkdl2    = 30;
const char adr_clkdl3    = 33;
const char adr_clkwd0    = 36;
const char adr_clkwd1    = 39;
const char adr_clkwd2    = 42;
const char adr_clkwd3    = 45;
const char adr_clkdiv0   = 48;
const char adr_clkdiv1   = 49;
const char adr_clkdiv2   = 50;
const char adr_clkdiv3   = 51;
const char adr_test      = 55;
const char adr_out0      = 56;
const char adr_out1      = 57;
const char adr_out2      = 58;
const char adr_out3      = 59;
const char adr_rst       =  0;
const char adr_pulse     =  1;
const char adr_level     =  2;


typedef struct {
  char *param;
  char  addr;
  char  enable;
  char  disable;
} SDGTOADV;

SDGTOADV outadv[] = {
  {"gd",    -1, 0x00, -1},
  {"clkgd", -1, 0x01, -1},
  {"clk",   -1, 0x02, -1},
  {"1k",    -1, 0x03, -1},
  {"none",  -1, 0x04, -1},
  {NULL, -1, -1, -1}
};

SDGTOADV testadv[] = {
  {"on",  -1, 0x01, -1},
  {"off", -1, 0x00, -1},
  {NULL, -1, -1, -1}
};


struct stchinfo { 
  int ch;
  int dlc;
  int dlf;
  int wdc;
  int wdf;
  int clkdl;
  int clkwd;
  int clkdiv;
  int outsel;
  float gddl;
  float gdwd;
  float clkstep;
  float clkgddl;
  float clkgdwd;
};

