/*
 * last modified : 15/02/03 18:31:16 
 *
 * Hidetada Baba (RIKEN)
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "libskelgto.h"
#include "cmdgdgtofunc.h"

COMMAND comlist[] = {
  {"status",    status,    "Read status", NULL},
  {"read",      read,      "Read parameters (for debug)", NULL},
  {"init",      init,      "Initialize all parameters to default value", NULL},
  {"eepr",      eepr,      "Load parameters from EEPROM", NULL},
  {"eepw",      eepw,      "Save current parameters to EEPROM", NULL},
  {"out0",      out0,      "Change Output0 signal source (OUT1,2)", "gd, clkgd, clk, 1k, none"},
  {"out1",      out1,      "Change Output1 signal source (OUT2,3)", "gd, clkgd, clk, 1k, none"},
  {"out2",      out2,      "Change Output2 signal source (OUT4,5)", "gd, clkgd, clk, 1k, none"},
  {"out3",      out3,      "Change Output3 signal source (OUT6,7)", "gd, clkgd, clk, 1k, none"},
  {"dlc0",      dlc0,      "Set Delay CG of GD0 (0-65535)", NULL},
  {"dlc1",      dlc1,      "Set Delay CG of GD1 (0-65535)", NULL},
  {"dlc2",      dlc2,      "Set Delay CG of GD2 (0-65535)", NULL},
  {"dlc3",      dlc3,      "Set Delay CG of GD3 (0-65535)", NULL},
  {"dlf0",      dlf0,      "Set Delay FG of GD0 (0-31)", NULL},
  {"dlf1",      dlf1,      "Set Delay FG of GD1 (0-31)", NULL},
  {"dlf2",      dlf2,      "Set Delay FG of GD2 (0-31)", NULL},
  {"dlf3",      dlf3,      "Set Delay FG of GD3 (0-31)", NULL},
  {"wdc0",      wdc0,      "Set Width CG of GD0 (0-65535)", NULL},
  {"wdc1",      wdc1,      "Set Width CG of GD1 (0-65535)", NULL},
  {"wdc2",      wdc2,      "Set Width CG of GD2 (0-65535)", NULL},
  {"wdc3",      wdc3,      "Set Width CG of GD3 (0-65535)", NULL},
  {"wdf0",      wdf0,      "Set Width FG of GD0 (0-31)", NULL},
  {"wdf1",      wdf1,      "Set Width FG of GD1 (0-31)", NULL},
  {"wdf2",      wdf2,      "Set Width FG of GD2 (0-31)", NULL},
  {"wdf3",      wdf3,      "Set Width FG of GD3 (0-31)", NULL},
  {"clkdl0",    clkdl0,    "Set Delay of CLKGD0 (0-16777215)", NULL},
  {"clkdl1",    clkdl1,    "Set Delay of CLKGD1 (0-16777215)", NULL},
  {"clkdl2",    clkdl2,    "Set Delay of CLKGD2 (0-16777215)", NULL},
  {"clkdl3",    clkdl3,    "Set Delay of CLKGD3 (0-16777215)", NULL},
  {"clkwd0",    clkwd0,    "Set Width of CLKGD0 (0-16777215)", NULL},
  {"clkwd1",    clkwd1,    "Set Width of CLKGD1 (0-16777215)", NULL},
  {"clkwd2",    clkwd2,    "Set Width of CLKGD2 (0-16777215)", NULL},
  {"clkwd3",    clkwd3,    "Set Width of CLKGD3 (0-16777215)", NULL},
  {"clkdiv0",   clkdiv0,   "Set Divide of CLKGD0 (0-255)", NULL},
  {"clkdiv1",   clkdiv1,   "Set Divide of CLKGD1 (0-255)", NULL},
  {"clkdiv2",   clkdiv2,   "Set Divide of CLKGD2 (0-255)", NULL},
  {"clkdiv3",   clkdiv3,   "Set Divide of CLKGD3 (0-255)", NULL},
  {"pulse",     pulse,     "Pulse output (8bit pattern)", NULL},
  {"level",     level,     "Level output (8bit pattern)", NULL},
  {"rst",       rst,       "Reset clock counter", NULL},
  {"test",      test,      "Test LED", "on/off"},
  {"noop",      noop,      "Dummy access to GTO", NULL},
  {"help",      help,      "Help", NULL},
  {NULL,        NULL,      NULL,   NULL} };

void quit(void){
  gto_close();
}

int main(int argc, char *argv[]){
  int i;

  if(argc < 3){
    help();
    return 0;
  }

  if(!gto_open(argv[1])){
    printf("Cannot connect %s\n", argv[1]);
    return 0;
  }

  gto_flush();

  i=0;
  while(comlist[i].com != NULL){
    if(!strcmp(comlist[i].com, argv[2])){
      if(!comlist[i].func(argv+3)){
	printf("Invalid argument %s\n\n", argv[3]);
	help();
      }
      break;
    }
    i++;
  }

  if(comlist[i].com == NULL){
    printf("Invalid function %s\n\n", argv[2]);
    help();
  }else{
    noop();
  }


  quit();

  return 0;
}
