#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <time.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <sys/shm.h>

#include "ridf.h"
#include "bbjsonb.h"
#include "bbtcp.h"
#include "bbweb.h"
#include "bbwebcom.h"
#include "ridfparser.h"
#include "ridf2json.h"

#define hport 8888
#define SEGNAME "segname.txt"

char rbuff[4096] = {0};
char *dbuff = NULL;
int sock = 0;
FILE *fd = NULL;

int info(void);
int setfile(char *arg);
int rewindfile(void);
int comerror(void);
int data(void);

WEBCOM comlist[] = {
  {"info", info, "get information", NULL},
  {"setfile", setfile, "set ridf file", NULL},
  {"rewindfile", rewindfile, "rewind data", NULL},
  {"data", data, "get latest data", NULL},
  {NULL, NULL, NULL, NULL}
};

int data(void){
  int evtn, sz, idx, flag;

  bbjsonb_begin();


  flag = 1;
  while(flag == 1){
    dbuff = nextevtdata(&evtn, &idx, &sz, &flag);
  }

  if(flag < 0){
    bbjsonb_charobj_single("error", "file is not opend");
  }else if (flag == 1){
    // nochance
    bbjsonb_charobj_single("info", "event buffer, try next data");
  }else{ // nomal data
    evt2json(dbuff, idx, sz);
  }
    
  bbjsonb_end();
  if(sock) httpres(sock, bbjsonb_buff(), bbjsonb_len());

  return 0;
}

int setfile(char *arg){
  char line[256] = {0};

  if(init_ridfparser(arg) == 1){
    sprintf(line, "set ridf %s", arg);
  }else{
    sprintf(line, "cannot open ridf %s", arg);
  }

  bbjsonb_begin();
  bbjsonb_charobj_single("info", line);
  bbjsonb_end();

  if(sock) httpres(sock, bbjsonb_buff(), bbjsonb_len());

  return 0;
}

int rewindfile(void){
  char line[256] = {0};

  if(rewind_ridfparser() == 1){
    sprintf(line, "rewind ridf");
  }else{
    sprintf(line, "ridf is not opend");
  }

  bbjsonb_begin();
  bbjsonb_charobj_single("info", line);
  bbjsonb_end();

  if(sock) httpres(sock, bbjsonb_buff(), bbjsonb_len());

  return 0;
}

int info(void){
  bbjsonb_begin();
  bbjsonb_charobj_single("file", status_ridfparser());
  bbjsonb_end();

  if(sock) httpres(sock, bbjsonb_buff(), bbjsonb_len());

  return 0;
}

int comerror(){
  bbjsonb_begin();
  bbjsonb_charobj_single("error", "invalid command");
  bbjsonb_end();

  if(sock) httpres(sock, bbjsonb_buff(), bbjsonb_len());

  return 0;
}

int main(int argc, char *argv[]){
  int hsock = 0;
  fd_set fdset;
  int selval, clen;
  struct sockaddr_in caddr;

  if(argc != 2){
    printf("webfileif FILENAME\n");
    exit(0);
  }

  init_ridfparser(argv[1]);

  /* Make Web port */
  hsock = srvsock(hport);
  bbjsonb_init();
  init_segname(SEGNAME);

  while(1){
    FD_ZERO(&fdset);
    FD_SET(hsock, &fdset);
    selval = select(hsock+1, &fdset, NULL, NULL, NULL);
    if(selval > 0){
      if(FD_ISSET(hsock, &fdset)){
        clen = sizeof(caddr);
        if((sock = accept(hsock, (struct sockaddr *)&caddr, (socklen_t *)&clen)) < 0){
          perror("Error in accept commain\n");
          return 0;
        }

        memset(rbuff, 0, 4096);
	recv(sock, rbuff, 4096, 0);

	if(!parseuri(rbuff, comlist)){
	  comerror();
	}
	close(sock);
      }
    }
  }

  return 0;
}
