#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <time.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <sys/shm.h>

#include "ridf.h"
#include "bbjsonb.h"
#include "bbtcp.h"
#include "bbweb.h"
#include "bbwebcom.h"
#include "ridfparser.h"
#include "libbabild.h"
#include "libcomjson.h"
#include "ridf2json.h"

#define hport 8888
#define SEGNAME "segname.txt"

char rbuff[4096] = {0};
char *dbuff = NULL;
int sock = 0;

int info(void);
int getconfig(void);
int getesconfig(void);
int nssta(void);
int stop(void);
int comerror(void);
int data(void);

WEBCOM comlist[] = {
  {"info", info, "get information", NULL},
  {"getconfig", getconfig, "get config", NULL},
  {"getesconfig", getesconfig, "get ES config", NULL},
  {"nssta", nssta, "start run without data storage", NULL},
  {"stop", stop, "stop run", NULL},
  {"data", data, "get latest data", NULL},
  {NULL, NULL, NULL, NULL}
};

int data(void){
  int sz = 0;

  if(!dbuff) return -1;
  sz = babild_dcopy(dbuff, 1024*1024);

  printf("***** data sz=%d\n", sz);
  
  bbjsonb_begin();
  evt2json(dbuff, 8, sz);
  bbjsonb_end();

  if(sock) httpres(sock, bbjsonb_buff(), bbjsonb_len());

  return 0;
}

int nssta(void){

  babild_set_eserhost();

  bbjsonb_begin();
  cj_nssta(NULL);
  bbjsonb_end();

  if(sock) httpres(sock, bbjsonb_buff(), bbjsonb_len());

  return 0;
}

int stop(void){

  bbjsonb_begin();
  cj_stop(NULL);
  bbjsonb_end();

  if(sock) httpres(sock, bbjsonb_buff(), bbjsonb_len());

  babild_resotre_eserhost();

  return 0;
}

int getesconfig(void){
  bbjsonb_begin();
  babild_get_esconfig();
  bbjsonb_end();
  if(sock) httpres(sock, bbjsonb_buff(), bbjsonb_len());

  return 0;
}

int getconfig(void){
  bbjsonb_begin();
  cj_getconfig();
  bbjsonb_end();
  if(sock) httpres(sock, bbjsonb_buff(), bbjsonb_len());

  return 0;
}

int info(void){
  bbjsonb_begin();
  bbjsonb_begin_obj(0);
  bbjsonb_intobj("test", 3);
  bbjsonb_end_obj();
  bbjsonb_end();

  if(sock) httpres(sock, bbjsonb_buff(), bbjsonb_len());

  return 0;
}

int comerror(){
  bbjsonb_begin();
  bbjsonb_charobj_single("error", "invalid command");
  bbjsonb_end();

  if(sock) httpres(sock, bbjsonb_buff(), bbjsonb_len());

  return 0;
}

int main(int argc, char *argv[]){
  int hsock = 0;
  fd_set fdset;
  int selval, clen, esefn;
  struct sockaddr_in caddr;

  if(argc != 2){
    printf("webesif EFN\n");
    exit(0);
  }

  esefn = strtol(argv[1], NULL, 0);
  if(esefn < 1 || esefn > 255){
    printf("invalid esefn %d\n", esefn);
    exit(0);
  }

  dbuff = malloc(1024*1024);

  /* Make Web port */
  hsock = srvsock(hport);
  bbjsonb_init();
  init_segname(SEGNAME);

  babild_init();
  babild_set_esefn(esefn);

  while(1){
    FD_ZERO(&fdset);
    FD_SET(hsock, &fdset);
    selval = select(hsock+1, &fdset, NULL, NULL, NULL);
    if(selval > 0){
      if(FD_ISSET(hsock, &fdset)){
        clen = sizeof(caddr);
        if((sock = accept(hsock, (struct sockaddr *)&caddr, (socklen_t *)&clen)) < 0){
          perror("Error in accept commain\n");
          return 0;
        }

        memset(rbuff, 0, 4096);
	recv(sock, rbuff, 4096, 0);

	if(parseuri(rbuff, comlist) < 0){
	  comerror();
	}
	close(sock);
      }
    }
  }

  return 0;
}
