#ifndef RIDFPARSER_H
#define RIDFPARSER_H

int getblockdata(FILE *fd, char *buff);

/** 
 * @fn
 * @brief  : get index of next event
 * @buff   : in  : data buffer
 * @idx    : in  : offset of buffer
 * @sz     : in  : size of data buffer
 * @nidx   : out : next event index
 * @sidx   : out : next segment index
 * @evtn   : out : event number
 * @ts     : out : timestamp (if ts event header)
 * @return : index of this event
 */
int getevtindex(char *buff, int idx, int sz, int *nidx, int *sidx,
		int *evtn, unsigned long long int *ts);

/** 
 * @fn
 * @brief  : get index of next segment
 * @buff   : in  : data buffer
 * @sidx   : in  : offset of buffer
 * @sz     : in  : size of data buffer
 * @nsidx  : out : next segment index
 * @segid  : out : segment id of this segment
 * @return : index of this segment
 */
int getsegindex(char *buff, int sidx, int sz, int *nsidx, int *segid);


/** 
 * @fn
 * @brief  : get buffer pointer of this segment
 * @buff   : in  : data buffer
 * @sidx   : in  : offset of buffer
 * @ssz    : out : size of segment content
 * @return : pointer of this segment content
 */
char* getsegbuff(char *buff, int sidx, int *ssz);

int evt2json(char *buff, int idx, int sz);
int init_ridfparser(char *file);
char* nextevtdata(int *evtn, int *idx, int *sz, int *flag);
int close_ridfparser(void);
int rewind_ridfparser(void);
int init_ridfparser(char *file);
char *status_ridfparser(void);


#endif
