#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

#include "ridf.h"
#include "ridfparser.h"

int gidx = 0;
int gsz = 0;
int gnidx = 0;
int gsidx = 0;
int gnsidx = 0;
int gevtn = 0;
unsigned long long int gts = 0;
char *gbuff = NULL;
FILE *gfd = NULL;

char gline[512] = {0};
char fpath[256] = {0};


int init_ridfparser(char *file){
  if(gfd){
    fclose(gfd);
  }

  if(!gbuff){
    gbuff = malloc(1024*1024);
  }

  gfd = fopen(file, "r");
  gidx = 0;
  gsz = 0;

  if(gfd == NULL){
    return -1;
  }

  sprintf(fpath, "%s", file);

  return 1;
}

int rewind_ridfparser(void){
  if(gfd){
    rewind(gfd);
    return 1;
  }

  return 0;
}

int close_ridfparser(void){
  if(gfd){
    fclose(gfd);
    return 1;
  }

  return 0;
}

char *status_ridfparser(void){
  
  if(!gfd){
    sprintf(gline, "ridf is not opened");
  }else{
    sprintf(gline, "ridf %s", fpath);
  }

  return gline;
}

// flag
// 0: normal
// 1: no evt data
// -2: end of file
// -3: not file open
char* nextevtdata(int *evtn, int *idx, int *sz, int *flag){

  if(!gfd){
    *flag = -3;
    return NULL;
  }

  // read block data
  if(gidx == 0){
    gsz = getblockdata(gfd, gbuff);
    gsidx = 0;
    if(gsz > 0){
      gidx = 8;
    }
  }

  if(gidx < 0){
    *flag = -2;
    return NULL;
  }

  *sz = gsz;

  // find evtdata
  gidx = getevtindex(gbuff, gidx, gsz, &gnidx, &gsidx, evtn, &gts);
  if(gidx < 0){
    gidx = 0;
    *idx = 0;
    *flag = 1;
  }else if(gnidx < gsz - 4){
    *idx = gidx;
    gidx = gnidx;
    *flag = 0;
  }else{
    gidx = 0;
    *idx = 0;
    *flag = 0;
  }

  return gbuff;
}

int getblockdata(FILE *fd, char *buff){
  int sz = 0;

  if(!feof(fd)){
    fread(buff, 8, 1, fd);
    memcpy((char *)&sz, buff, 4);
    sz = (sz & 0x003fffff) * 2;
    fread(buff+8, sz-8, 1, fd);
  }else{
    return -1;
  }

  return sz;
}

int getevtindex(char *buff, int idx, int sz, int *nidx, int *sidx,
		int *evtn, unsigned long long int *ts){
  int n = 0;
  int hd = 0;
  int cid=0, csz=0;

  n = idx;

  if(sz < 4){
    return 0;
  }

  while(n < sz-4){
    memcpy((char *)&hd, buff+n, 4);
    cid = (hd & 0x0fc00000) >> 22;
    csz = (hd & 0x003fffff) * 2;
    if(cid == 3 || cid == 6){
      *nidx = n + csz;
      memcpy((char *)evtn, buff+n+8, 4);
      if(cid == 3){
	*sidx = n + 12;
	*ts = 0;
      }else{  // cid=6 with TS
	*sidx = n + 20;
	memcpy((char *)ts, buff+n+12, 8);
      }
      return n;
    }else{
      n += csz;
    }
  }

  return -1;
}

int getsegindex(char *buff, int sidx, int sz, int *nsidx, int *segid){
  int n = 0, hd = 0, csz=0, cid=0;


  n = sidx;

  while(n < sz-4){
    memcpy((char *)&hd, buff+n, 4);
    cid = (hd & 0x0fc00000) >> 22;
    csz = (hd & 0x003fffff) * 2;
    if(cid == 4){
      *nsidx = n + csz;
      memcpy((char *)segid, buff+n+8, 4);
      return n;
    }else{
      n += csz;
    }
  }  

  return -1;
}

char* getsegbuff(char *buff, int sidx, int *ssz){
  int hd = 0, csz=0, cid=0;

  memcpy((char *)&hd, buff+sidx, 4);
  cid = (hd & 0x0fc00000) >> 22;
  csz = (hd & 0x003fffff) * 2;
  if(cid == 4){
    *ssz = csz - 12;
    return buff + sidx + 12;
  }else{
    return 0;
  }
}
