#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "bbjsonb.h"
#include "ridf.h"
#include "ridfparser.h"
#include "segidlist.h"
#include "ridf2json.h"

/*
bsid.revision, bsid.device, bsid.focal,
  bsid.detector, bsid.module);
*/

int nname = 0;
char *segname[64] = {0};
int segnameid[64] = {0};

char* find_segname(int segid){
  int i;

  for(i=0;i<64;i++){
    if((segid & 0xffffff00) == segnameid[i]){
      return segname[i];
    }
  }

  return NULL;
}

void show_segname(void){
  int i;
  for(i=0;i<nname;i++){
    printf("%08x : %s\n", segnameid[i], segname[i]);
    i++;
    if(i==64){
      break;
    }
  }
}

int init_segname(char *file){
  FILE *fd;
  int tdev, tfp, tdet;
  char *tnam;

  nname = 0;

  if((fd = fopen(file, "r")) == NULL){
    return 0;
  }

  while(!feof(fd)){
    tnam = calloc(1, 256);
    if(fscanf(fd, "%d,%d,%d,%s", &tdev, &tfp, &tdet, tnam) == 4){
      segname[nname] = tnam;
      segnameid[nname] = MKSEGID(tdev, tfp, tdet, 0);
    }else{
      break;
    }

    nname++;
    if(nname == 64){
      break;
    }
  }

  fclose(fd);
  return 1;
}

void parse_c16(int segid, int evtn, char *buff, int sz){
  char js[256] = {0};
  char *tsegname;
  struct stbsegid bseg;

  memcpy((char *)&bseg, (char *)&segid, 4);
  bbjsonb_begin_obj(NULL);
  sprintf(js, "%d-%d-%d", bseg.device, bseg.focal, bseg.detector);
  bbjsonb_charobj("segid", js);
  tsegname = find_segname(segid);
  if(tsegname){
    bbjsonb_charobj("segname", find_segname(segid));
  }else{
    bbjsonb_charobj("segname", js);
  }
  bbjsonb_intobj("module", bseg.module);
  bbjsonb_intobj("ndata", sz/2);
  //bbjsonb_shortarray("data", (unsigned short *)buff, sz/2);
  bbjsonb_shortarray("data", (short *)buff, sz/2);
  bbjsonb_end_obj();
}

void parse_c32(int segid, int evtn, char *buff, int sz){
  char js[256] = {0};
  struct stbsegid bseg;
  char *tsegname;

  memcpy((char *)&bseg, (char *)&segid, 4);
  bbjsonb_begin_obj("segment");
  sprintf(js, "%d-%d-%d", bseg.device, bseg.focal, bseg.detector);
  bbjsonb_charobj("segid", js);
  tsegname = find_segname(segid);
  if(tsegname){
    bbjsonb_charobj("segname", find_segname(segid));
  }else{
    bbjsonb_charobj("segname", js);
  }
  bbjsonb_intobj("module", bseg.module);
  bbjsonb_intobj("ndata", sz/4);
  bbjsonb_intarray("data", (int *)buff, sz/4);
  //bbjsonb_intarray("data", (unsigned int *)buff, sz/4);
  bbjsonb_end_obj();
}


int evt2json(char *buff, int idx, int sz){
  int nidx, sidx, nsidx, segid;
  unsigned long long int ts;
  int tidx, evtn;
  char *segdata;
  int ssz;
  struct stbsegid bseg;

  if((tidx = getevtindex(buff, idx, sz, &nidx, &sidx, &evtn, &ts)) >= 0){
    bbjsonb_intobj("evtn", evtn);
    bbjsonb_begin_array("segment");
    while((sidx = getsegindex(buff, sidx, sz, &nsidx, &segid)) >= 0){
      segdata = getsegbuff(buff, sidx, &ssz);
      memcpy((char *)&bseg, (char *)&segid, 4);
      switch(bseg.module){
      case C16:
	parse_c16(segid, evtn, segdata, ssz);
	break;
      case C24:
      case C32:
	parse_c32(segid, evtn, segdata, ssz);
	break;
      default:
	break;
      }
      sidx = nsidx;
    }
    bbjsonb_end_array();
  }else{
    printf("***** data error =%d\n", tidx);
    bbjsonb_begin_array("event");
    bbjsonb_charobj_single("error", "no valid event data");
    bbjsonb_end_array();
    return -1;
  }

  idx = nidx;

  return nidx;
}
