#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <fcntl.h>
#include <string.h>
#include <netdb.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/select.h>
#include <sys/socket.h>
#include <sys/sem.h>
#include <netinet/in.h>

#include "bbcom.h"
#include "libbabild.h"
#include "libcomjson.h"
#include "bbjsonb.h"
#include "bbtcp.h"


#ifdef DEBUG
#define DB(x) x
#else
#define DB(x)
#endif

extern struct struninfo runinfo;
extern struct stdaqinfo daqinfo;
extern struct stefrc efrc;

int evtn[MAXEF] = {0};
char esname[64] = {0};
char *ofstr[3] = {"off\0", "on\0", "scr\0"};
char *runstatstr[4] =  {"IDLE\0", "START\0", "NSSTA\0", "WAITSTOP\0"};

int cj_chkcom(char *com, char **comlist){
  int ret = -1, i;

  i = 0;
  while(comlist[i]){
    if(!strcmp(com, comlist[i])){
      ret = i/3;
      break;
    }
    i += 3;
  }

  return ret;
}


int cj_exec_psh(char *arg){
  FILE *pfp;
  char buff[1024];
  char js[128] = {0};

  memset(buff, 0, sizeof(buff));

  if(strlen(arg) <= 0) return 0;

  if((pfp = popen(arg, "r")) == NULL){
    sprintf("Can't exec %s", arg);
    bbjsonb_charobj("error", js);
    return 0;
  }else{
    fread(buff, 1, sizeof(buff)-1, pfp);
    if(pclose(pfp) < 0){
      sprintf(js, "Unknown error : %s", arg);
      bbjsonb_charobj("error", js);
      return 0;
    }
    //printf("%s", buff);
    if(buff[0] == 'O' && buff[1] == 'K'){
      // OK
      return 1;
    }else{
      // Error
      return 0;
    }
  }
}

int cj_exec_nsh(char *arg){
  char buff[1024];

  memset(buff, 0, sizeof(buff));
  sprintf(buff, "%s &", arg);
  system(buff);

  return 1;
}


int cj_escon(char *arg){
  int essock, efid;
  char js[256] = {0};

  efid = -1;
  essock = 0;
  if(arg == NULL){
    //printf("no EFSID\n");
    bbjsonb_charobj("error", "no EFSID");
    return 0;
  }
  
  efid = strtol(arg, NULL, 0);
  if(efid < 0 || efid > MAXEF){

    sprintf(js, "0 < EFSID < %d", MAXEF);
    bbjsonb_charobj("error", js);
    return 0;
  }
  if(!daqinfo.eflist[efid].ex){
    bbjsonb_charobj("error", "Invalid EFSID");
    return 0;
  }
  
  if(!(essock = mktcpsend(daqinfo.eflist[efid].host, ESCOMPORT+efid))){
    sprintf(js, "Can't connet to babies id=%d", efid);
    bbjsonb_charobj("error", js);
    return 0;
  }

  return essock;
}

int cj_getevtnumber(int ebn){

  bbjsonb_intobj("eventbuiltnumber", ebn);

  return 0;
}

int cj_getebrate(long long int totsize){
  int dt;
  double ts, rs;
  time_t now;
  char js[256] = {0};

  time(&now);
  ts = (double)totsize/1024./1024.*2.;

  if(runinfo.runstat){
    dt = (int)now - runinfo.starttime;
  }else{
    dt = runinfo.stoptime - runinfo.starttime;
  }

  if(totsize > 0){
    rs = ts / (double)dt;
    sprintf(js, "%7.2f (MB)", ts);
    bbjsonb_charobj("eventbuiltsize", js);
    sprintf(js, "%7.2f (MB/s)", rs);
    bbjsonb_charobj("eventbuiltrate", js);
  }else{
    //printf("No event build\n");
    bbjsonb_charobj("eventbuiltsize", "none");
    bbjsonb_charobj("eventbuiltrate", "none");
  }

  return 0;
}

void cj_show_runinfo(void){
  time_t ttime;
  char chst[80];
  struct tm *strtime;

  memset(chst, 0, sizeof(chst));

  bbjsonb_begin_obj("runinfo");
  bbjsonb_charobj("runname", daqinfo.runname);
  bbjsonb_intobj("runnumber", runinfo.runnumber);
  bbjsonb_charobj("runstatus", runstatstr[runinfo.runstat]);
  ttime = runinfo.starttime;
  strtime = localtime(&ttime);
  strftime(chst, sizeof(chst), "%d-%b-%y %X", strtime);
  bbjsonb_charobj("startdate", chst);
  if(!runinfo.runstat){
    ttime = runinfo.stoptime;
    strtime = localtime(&ttime);
    strftime(chst, sizeof(chst), "%d-%b-%y %X", strtime);
    bbjsonb_charobj("stopdate", chst);
  }
  bbjsonb_charobj("header", runinfo.header);
  if(!runinfo.runstat){
    bbjsonb_charobj("ender", runinfo.ender);
  }
  bbjsonb_end_obj();
  
}

void cj_show_ebinfo(void){
  bbjsonb_begin_obj("ebinfo");
  bbjsonb_intobj("efn", daqinfo.efn);
  bbjsonb_intobj("ebsize", daqinfo.ebsize);
  bbjsonb_intobj("ebsizekb", daqinfo.ebsize*2/1024);
  bbjsonb_end_obj();
}

void cj_show_daqinfo(void){
  cj_show_ebinfo();
  cj_show_runinfo();
  cj_show_eflist();
}

int cj_nssta(char *arg){
  int ret;
  char js[80] = {0};
  
  ret = babild_nssta();

  if(!ret){
    if(daqinfo.babildes){
      bbjsonb_charobj("error", "Can't start, babild is babildes mode");
    }else{
      sprintf(js, "Can't start, because already start of somze error %d", ret);
      bbjsonb_charobj("error", js);
    }
  }else{
    cj_show_runinfo();
  }

  return 0;
}

int cj_stop(char *arg){
  int ret;

  printf("cj stop command\n");
  ret = babild_stop();
  printf("cj wait stop\n");

  if(!ret){
    bbjsonb_charobj("error", "Can't stop, now stopping or some error or babildes mode");
    return 0;
  }

  usleep(300000);

  while(runinfo.runstat != STAT_RUN_IDLE
	&& runinfo.runstat != STAT_RUN_WAITSTOP){
    usleep(10000);
  }

  cj_show_runinfo();

  return 0;
}

int cj_setebsize(int newn){
  char js[128]={0};
  int ret = 0;

  if(newn < 0 || newn > EB_EFBLOCK_MAXSIZE){
    
    sprintf(js, "Please set 0 < ebsize < %d (%d kB)", EB_EFBLOCK_MAXSIZE,
	   EB_EFBLOCK_MAXSIZE*2/1024);
    bbjsonb_charobj("error", js);
    return 0;
  }

  ret = babild_set_ebsize(newn);

  if(!ret){
    bbjsonb_charobj("error", "Run is now running, can't change parameters");
    return 0;
  }

  return 1;
}

void cj_show_eflist(void){
  int i;

  bbjsonb_begin_array("eflist");
  for(i=0; i<MAXEF; i++){
    if(daqinfo.eflist[i].ex){
      bbjsonb_begin_obj(0);
      bbjsonb_intobj("efn", i);
      bbjsonb_charobj("host", daqinfo.eflist[i].host);
      bbjsonb_charobj("name", daqinfo.eflist[i].name);
      bbjsonb_charobj("onoff", ofstr[daqinfo.eflist[i].of]);
      bbjsonb_end_obj();
    }
  }
  bbjsonb_end_array();

}

void cj_show_efrc(struct stefrc efrc){
  bbjsonb_begin_obj("efrc");
  bbjsonb_intobj("efn", efrc.efid);
  bbjsonb_intobj("erport", efrc.erport);
  bbjsonb_charobj("erhost", efrc.erhost);
  bbjsonb_intobj("hd1", efrc.hd1);
  bbjsonb_charobj("hd1dir", efrc.hd1dir);
  bbjsonb_intobj("hd2", efrc.hd2);
  bbjsonb_charobj("hd2dir", efrc.hd2dir);
  bbjsonb_intobj("mt", efrc.mt);
  bbjsonb_charobj("rtdrv", efrc.mtdir);
  bbjsonb_intobj("connect", efrc.connect);
  bbjsonb_end_obj();
}

int cj_seteflist(int efn){
  char js[64] = {0};

  if(efn < 0 || efn >= MAXEF){
    sprintf(js, "0 < EFN < %d", MAXEF);
    bbjsonb_charobj("error", js);
    return 0;
  }

  babild_set_esefn(efn);    
  cj_show_eflist();

  return 1;
}

int cj_exec_sh(char *arg){
  system(arg);
  return 0;
}

int cj_getconfig(void){

  cj_show_daqinfo();

  return 0;
}


int cj_getesconfig(char *arg){
  int sock, len, com;

  DB(printf("babicon: getesconfig %s\n", arg));

  if(!(sock = cj_escon(arg))) return 0;
  
  com = ES_GET_CONFIG;
  len = sizeof(com);
  send(sock, (char *)&len, sizeof(len), 0);
  send(sock, (char *)&com, len, 0);
  recv(sock, (char *)&len, sizeof(len), MSG_WAITALL);
  recv(sock, (char *)&efrc, len, MSG_WAITALL);
  close(sock);

  cj_show_efrc(efrc);
  
  return 1;
}

int cj_esquit(char *arg){
  int sock, len, com;
  DB(printf("babicon: esquit %s\n", arg));

  if(!(sock = cj_escon(arg))) return 0;
  
  com = ES_QUIT;
  len = sizeof(com);
  send(sock, (char *)&len, sizeof(len), 0);
  send(sock, (char *)&com, len, 0);
  close(sock);

  return 1;
}

int cj_setesconfig(char *arg){
  int sock, len, com;
  char *rarg[80];
  int ar, fl;

  fl = 1;
  com = 0;
  DB(printf("babicon: setesconfig %s\n", arg));
  ar = striparg(arg, rarg);
  if(ar != 3) fl = 0;

  if(!cj_getesconfig(rarg[0])){
    return 0;
  }

  if(ar == 3){
    if(!strcmp(rarg[1], "hd1")){
      if(!strcmp(rarg[2], "on")){
	efrc.hd1 = 1;
      }else if(!strcmp(rarg[2], "off")){
	efrc.hd1 = 0;
      }else{
	fl = 0;
      }
    }else if(!strcmp(rarg[1], "hd2")){
      if(!strcmp(rarg[2], "on")){
	efrc.hd2 = 1;
      }else if(!strcmp(rarg[2], "off")){
	efrc.hd2 = 0;
      }else{
	fl = 0;
      }
    }else if(!strcmp(rarg[1], "mt")){
      if(!strcmp(rarg[2], "on")){
	efrc.mt = 1;
      }else if(!strcmp(rarg[2], "off")){
	efrc.mt = 0;
      }else{
	fl = 0;
      }
    }else if(!strcmp(rarg[1], "hd1dir")){
      strncpy(efrc.hd1dir, rarg[2], sizeof(efrc.hd1dir)-1);
    }else if(!strcmp(rarg[1], "hd2dir")){
      strncpy(efrc.hd2dir, rarg[2], sizeof(efrc.hd2dir)-1);
    }else if(!strcmp(rarg[1], "rtdrv")){
      strncpy(efrc.mtdir, rarg[2], sizeof(efrc.mtdir)-1);
    }else if(!strcmp(rarg[1], "host")){
      strncpy(efrc.erhost, rarg[2], sizeof(efrc.erhost)-1);
    }
  }

  if(fl){
    if(!(sock = cj_escon(rarg[0]))) return 0;
  
    com = ES_SET_CONFIG;
    len = sizeof(com) + sizeof(efrc);
    send(sock, (char *)&len, sizeof(len), 0);
    send(sock, (char *)&com, sizeof(com), 0);
    send(sock, (char *)&efrc, sizeof(efrc), 0);
    recv(sock, (char *)&len, sizeof(len), MSG_WAITALL);
    recv(sock, (char *)&efrc, len, MSG_WAITALL);
    close(sock);

    cj_getesconfig(rarg[0]);
    cj_show_efrc(efrc);
    
  }else{
    bbjsonb_charobj("error", "invalid command for setesconfig");
    return 0;
  }


  return 1;
}

int cj_reloadesdrv(char *arg){
  int sock, len, com;
  char *rarg[80];
  //int ar;

  striparg(arg, rarg);
  com = 0;
  DB(printf("babicon: setesconfig %s\n", arg));

  if(!(sock = cj_escon(rarg[0]))) return 0;

  com = ES_RELOAD_DRV;
  len = sizeof(com);
  send(sock, (char *)&len, sizeof(len), 0);
  send(sock, (char *)&com, sizeof(com), 0);
  close(sock);

  cj_getesconfig(rarg[0]);
  cj_show_efrc(efrc);

  return 1;
}

void cj_show_evtn(char *arg){
  int i;

  bbjsonb_begin_array("lastevtn");
  for(i=0; i<MAXEF; i++){
    if(daqinfo.eflist[i].ex && daqinfo.eflist[i].of == EB_EFLIST_ON){
      bbjsonb_begin_obj(0);
      bbjsonb_intobj("efn", i);
      bbjsonb_charobj("name", daqinfo.eflist[i].name);
      bbjsonb_intobj("evtn", evtn[i]);
      bbjsonb_end_obj();
    }
  }
  bbjsonb_end_array();
}

int cj_getevtn(char *arg){
  int sock, len, com, i;
  char chefn[80];

  DB(printf("babicon: getevtn %s\n", arg));

  for(i=0;i<MAXEF;i++){
    if(daqinfo.eflist[i].ex && daqinfo.eflist[i].of == EB_EFLIST_ON){
      memset(chefn, 0, sizeof(chefn));
      sprintf(chefn, "%d", i);
      if(!(sock = cj_escon(chefn))) return 0;
      com = ES_GET_EVTN;
      len = sizeof(com);
      send(sock, (char *)&len, sizeof(len), 0);
      send(sock, (char *)&com, len, 0);
      recv(sock, (char *)&len, sizeof(len), MSG_WAITALL);
      recv(sock, (char *)&evtn[i], len, MSG_WAITALL);
      close(sock);
    }
  }

  cj_show_evtn(NULL);
  
  return 1;
}

int cj_getesevtnumber(char *arg){
  cj_getevtn(NULL);

  return 1;
}

int cj_whoareyou(char *arg){
  int sock, len, com;

  DB(printf("babicon: whoareyou %s\n", arg));

  if(!(sock = cj_escon(arg))) return 0;
  
  com = WHOAREYOU;
  len = sizeof(com);
  send(sock, (char *)&len, sizeof(len), 0);
  send(sock, (char *)&com, len, 0);
  recv(sock, (char *)&len, sizeof(len), MSG_WAITALL);
  recv(sock, (char *)&esname, len, MSG_WAITALL);
  close(sock);

  bbjsonb_begin_obj("whoareyou");
  bbjsonb_charobj("efn", arg);
  bbjsonb_charobj("esname", esname);
  bbjsonb_end_obj();

  return 1;
}

int cj_esconnect(char *arg){
  int sock, len, com;

  DB(printf("babicon: esconnect %s\n", arg));
  if(!(sock = cj_escon(arg))) return 0;
  com = ES_CON_EFR;
  len = sizeof(com);
  send(sock, (char *)&len, sizeof(len), 0);
  send(sock, (char *)&com, len, 0);
  close(sock);

  return 1;
}

int cj_esdisconnect(char *arg){
  int sock, len, com;

  DB(printf("babicon: esdisconnect %s\n", arg));

  if(!(sock = cj_escon(arg))) return 0;
  com = ES_DIS_EFR;
  len = sizeof(com);
  send(sock, (char *)&len, sizeof(len), 0);
  send(sock, (char *)&com, len, 0);
  close(sock);

  return 1;
}

