#ifndef LIBBABLID_H
#define LIBBABILD_H

#ifdef __cplusplus
extern "C" {
#endif

/* Custom values */
//#define DEBUG     1    // If define DEBUG, shows debug messages 

#define LEFN(x) (x & 0xff) ///< real EFN to local EFN (0-255)    

// Selection of buffer size, w/o HUGEBUFF, LARGEBUFF => 256kB buffer
#define HUGEBUFF    1    // 8MB Buffer
//#define LARGEBUFF    1    // 2MB Buffer

// Receiver port of babild
#define ERRCVPORT   17601
#define ESCOMPORT   17651  // port will be ESCOMPORT + EFN


#ifdef HUGEBUFF
#define EB_EFBLOCK_SIZE 0x800000   ///< Usual max size of block data = 8MB
#else
#ifdef LARGEBUFF
#define EB_EFBLOCK_SIZE 0x200000   ///< Usual max size of block data = 2MB 
#else
#define EB_EFBLOCK_SIZE 0x20000   ///< Usual max size of block data = 256kB
#endif 
#endif
#define EB_EFBLOCK_BUFFSIZE EB_EFBLOCK_SIZE * 2
#define BABIRL_COM_SIZE    1024*10 ///< Buffer size for babirl tcp commands 

#define EB_EFBLOCK_MAXSIZE 0x80000 ///< Temp max size of block data = 1MB

/** babies tcp commands */
#define ES_SET_CONFIG    1
#define ES_GET_CONFIG    2
#define ES_RUN_START     3
#define ES_RUN_NSSTA     4
#define ES_RUN_STOP      5
#define ES_RELOAD_DRV    6
#define ES_GET_EVTN      8    // Get last event number
#define ES_GET_RUNSTAT   9    // Get Run status
#define ES_CON_EFR      11    // Connect EFS to EFR
#define ES_DIS_EFR      12    // Disconnect EFS to EFR
#define ES_RUN_DRY      13    // start dry run
#define ES_RUN_DRYSTOP  14    // terminate dry run / client
#define ES_QUIT         99
/** babies tcp arguments */
#define ES_EF_ON    0x00000000    // Join event build
#define ES_EF_OFF   0x80000000    // Not join event build
#define WHOAREYOU        98


#define EB_EFLIST_OFF     0
#define EB_EFLIST_ON      1
#define EB_EFLIST_SCR     2
#define EB_EFLIST_PAS     3


// socket command
#define INF_MK_TCPCLIENT  106

/* Macros */
#define RIDF_MKHD1(a,b,c) ((a&0x3)<<28|(b&0x3f)<<22|(c&0xffffff))
#define RIBF_MKHD2(d)      (d & 0xffffffff)
#define RIDF_LY(x) ((x & 0x30000000) >> 28) // Layer
#define RIDF_CI(x) ((x & 0x0fc00000) >> 22) // Class ID
#define RIDF_SZ(x)  (x & 0x003fffff)        // Block Size
#define RIDF_EF(x)  (x & 0xffffffff)        // Event Fragment Number


/* Bits */
#define RIDF_LY0               0
#define RIDF_LY1               1
#define RIDF_LY2               2
#define RIDF_LY3               3


/* Class ID */
#define RIDF_EF_BLOCK          0
#define RIDF_EA_BLOCK          1
#define RIDF_EAEF_BLOCK        2
#define RIDF_EAF_BLOCK         2
#define RIDF_EVENT             3
#define RIDF_SEGMENT           4
#define RIDF_COMMENT           5
#define RIDF_EVENT_TS          6
#define RIDF_BLOCK_NUMBER      8
#define RIDF_END_BLOCK         9
#define RIDF_SCALER            11
#define RIDF_NCSCALER          11
#define RIDF_CSCALER           12
#define RIDF_NCSCALER32        13
#define RIDF_TIMESTAMP         16
#define RIDF_STATUS            21

/* Comment ID */
#define RIDF_COMMENT_TEXT        0
#define RIDF_COMMENT_RUNINFO_ASC 1
#define RIDF_COMMENT_EFINFO_ASC  2
#define RIDF_COMMENT_DAQINFO_BIN 3
#define RIDF_COMMENT_RUNINFO_BIN 4

/* Comment ID */
#define RIDF_STATUS_START_XML    11
#define RIDF_STATUS_STOP_XML     12

#define SIZEOFINT 4
#define SIZEOFTS  8

#define RIDF_HD_SZ             4
#define RIDF_HDEVT_SZ          6
#define RIDF_HDSEG_SZ          6
#define RIDF_HDSCR_SZ          8
#define RIDF_HDEVTTS_SZ        10

// for run status
#define STAT_RUN_IDLE         0
#define STAT_RUN_START        1
#define STAT_RUN_NSSTA        2
#define STAT_RUN_WAITSTOP     3

#define MAXEF 256
#define MAXHD 10
#define MAXMT 1
#define u64 unsigned long long int

struct steflist{
  int  ex;   ///< 0=nan, 1=exist
  int  of;    ///< 0=off, 1=on, 2=scr
  char name[80];   ///< Name of EF
  char host[80];   ///< Host name or IP address of EF
};

/*! Structre for HD list */
struct sthdlist{
  //!  0=nan, 1=exist
  int  ex;
  //!  0=off, 1=on
  int  of;
  //!  Path where into saved of this HD
  char path[80];
  //!  Free size of this HD
  u64  free;
  //!  Full size of this HD
  u64  full;
  //!  Maximam size of file size
  u64  maxsize;
};

/*! Structure for MT List */
struct stmtlist{
  int  ex; /// 0=nan, 1=exist
  int  of; /// 0=off, 1=on
  char path[80];
  u64  maxsize;
};

struct stdaqinfo{
  char runname[80]; ///< Run name (File name)
  int runnumber;    ///< Run number
  int ebsize;       ///< Event build size
  int efn;          ///< Event fragment number of this
  int babildes;     ///< Flag for babildes mode (1=babildes, 0=standalone)
  struct steflist eflist[MAXEF];  ///< Event fragment list
  struct sthdlist hdlist[MAXHD];  ///< HDD list
  struct stmtlist mtlist[MAXMT];  ///< MT list
};

struct struninfo{
  int runnumber;   ///< Run number (same as stdaqinfo.runnumber)
  int runstat;     ///< Run status (read only)
  int starttime;   ///< Run start time (read only)
  int stoptime;    ///< Run stop time (read only)
  char header[80]; ///< Run header comment
  char ender[80];  ///< Run enver comment
};


struct stefrc{
  int efid;          ///< EFID
  char runname[80];  ///< Run name (RIDF file name)
  int runnumber;     ///< Run number
  short erport;      ///< ER port
  short comport;     ///< ES communication port
  char erhost[80];   ///< ER hostname
  int hd1;           ///< Flag for HDD1
  char hd1dir[80];   ///< Path of HDD1
  int hd2;           ///< Flag for HDD2
  char hd2dir[80];   ///< Path of HDD2
  int mt;            ///< Flag for MT
  char mtdir[80];    ///< Path of MT
  int connect;       ///< Connectivity of ER (0=disconnected., 1=connected)
};


  /* prototype */
  void  babild_init(void);
  int babild_efrmain(void);
  int babild_start(void);
  int babild_nssta(void);
  int babild_stop(void);
  int babild_set_esefn(int efn);
  int babild_set_ebsize(int sz);
  int babild_get_esconfig(void);
  int babild_set_eserhost(void);
  int babild_resotre_eserhost(void);
  char* babild_data(void);
  int babild_dcopy(char *buff, int max);


#ifdef __cplusplus
}
#endif

#endif
