#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/time.h>
#include <arpa/inet.h>
#include <pthread.h>

#include "libbabild.h"
#include "libcomjson.h"
#include "bbtcp.h"

//#define DEBUG

#ifdef DEBUG
#define DB(x) x
#else
#define DB(x)
#endif

/* globals */
pthread_t efrthre;
struct struninfo runinfo;
int esefn = 0;
int gloevtn = 0;
int totsize = 0;
int blkn = 0;

struct struninfo runinfo;
struct stdaqinfo daqinfo;
struct stefrc efrc;

char orgeshost[256] = {0};

static pthread_mutex_t datamutex = PTHREAD_MUTEX_INITIALIZER;
static char *data = NULL;

void babild_init(void){

  data = malloc(EB_EFBLOCK_BUFFSIZE);

  pthread_mutex_init(&datamutex, NULL);

  memset((char *)&runinfo, 0, sizeof(runinfo));
  memset((char *)&daqinfo, 0, sizeof(daqinfo));

  sprintf(daqinfo.runname, "webif");
  daqinfo.ebsize = 8192;
  daqinfo.efn = 1;

  pthread_create(&efrthre, NULL, (void *)babild_efrmain, NULL);
}

int babild_set_esefn(int efn){
  int i;

  if(runinfo.runstat != STAT_RUN_IDLE){
    return 0;
  }

  for(i=0;i<MAXEF;i++){
    daqinfo.eflist[i].ex = 0;
    daqinfo.eflist[i].of = 0;
  }
  
  daqinfo.eflist[efn].ex = 1;
  daqinfo.eflist[efn].of = EB_EFLIST_ON;
  sprintf(daqinfo.eflist[efn].name, "localhost");
  sprintf(daqinfo.eflist[efn].host, "localhost");
  esefn = efn;

  return 1;
}

int babild_set_ebsize(int sz){
  int ret = 0;

  if(runinfo.runstat == STAT_RUN_IDLE){
    daqinfo.ebsize = sz;
    ret = 1;
  }else{
    ret = 0;
  }

  return ret;
}

int babild_efrmain(void){
  char *buff;
  int len, er;
  int ebn = 0;
  int clen, sock;
  int ebdfd = 0;
  int ret = 0;
  struct sockaddr_in caddr;

  buff = malloc(EB_EFBLOCK_BUFFSIZE);
  if(buff == NULL){
    return 0;
  }

  if((ebdfd = mktcpsock(ERRCVPORT)) == -1){
    return 0;
  }

  clen = sizeof(caddr);

  while(1){
  if((sock = accept(ebdfd, (struct sockaddr *)&caddr, (socklen_t *)&clen)) < 0){
    perror("Error in accept eb_connect\n");
    return 0;
  }
  recv(sock, (char *)&ebn, sizeof(ebn), MSG_WAITALL);
  ebn = LEFN(ebn);
  if(ebn > 0 && ebn < MAXEF){
    //DB(printf("babild: eb_connect ebn %d\n", ebn));
    ret = 1;
  }else{
    DB(printf("babild: eb_connect invalid ebn %d\n", ebn));
    ret = 0;
  }
  send(sock, (char *)&ret, sizeof(ret), 0);

  while(1){
    DB(printf("efrmain[%d] wait recv sock=%d\n", ebn, sock));
    if((er = recv(sock, (char *)&len, sizeof(len), MSG_WAITALL)) < 1){
      DB(printf("efrmain[%d]: EF%d closed er=%d errorn=%d\n", ebn, ebn, er, errno));
      close(sock);
      break;
    }
    DB(printf("efrmain[%d] len=%d\n", ebn, len));
    if(len > 0){
      if((er = recv(sock, buff, len, MSG_WAITALL)) < 1){
      }
      pthread_mutex_lock(&datamutex);
      memcpy(data, buff, len);
      pthread_mutex_unlock(&datamutex);
    }else{
      DB(printf("efrmain[%d]: End of Run EFN=%d\n", ebn, ebn));
      len = (ebn * -1) - 1;

      runinfo.runstat = STAT_RUN_IDLE;
    }
    usleep(1000);
  }

  DB(printf("Closing efrmain[%d]\n", ebn));

  if(runinfo.runstat != STAT_RUN_IDLE){
    DB(printf("Clash efr\n"));
  }

  }

  // cannot process here
  if(buff) free(buff);

  pthread_cancel(efrthre);
  
  return 1;
}


int escommand(int com){
  int len, rlen, fret = 1;
  int essock = 0;
  int ret[1024];
  int arg;
  char buff[64];

  memset((char *)&essock, 0, sizeof(essock));
  if(!(essock = mktcpsend_tout(daqinfo.eflist[esefn].host, ESCOMPORT+esefn, 1))){
    fret = 0;
  }else{
    //DB(printf("essock: %d = %d\n", i, essock[i]));
  }
  
  if(essock){
    len = sizeof(com);
    memcpy(buff, (char *)&com, sizeof(com));
    if(com == ES_RUN_START || com == ES_RUN_NSSTA){
      if(daqinfo.eflist[esefn].of){
	// for on and scr
	arg = ES_EF_ON;
      }else{
	// for off
	// This option is no meaning for now
	arg = ES_EF_OFF;
      }
      len += sizeof(arg);
      memcpy(buff+sizeof(com), (char *)&arg, sizeof(arg));
    }
    send(essock, (char *)&len, sizeof(len), 0);
    send(essock, buff, len, 0);
    recv(essock, (char *)&rlen, sizeof(rlen), MSG_WAITALL);
    recv(essock, (char *)ret, rlen, MSG_WAITALL);
      
    close(essock);
  }else{
    //close(essock[i]);
  }
    
  return fret;
}


int babild_nssta(){
  time_t now;

  if(runinfo.runstat != STAT_RUN_IDLE){
    return 0;
  }

  gloevtn = 0;

  if(escommand(ES_RUN_NSSTA)){
    /* Start time */
    time(&now);
    runinfo.starttime = (int)now;
    gloevtn = 0;
    totsize = 0;
    blkn = 0;

    runinfo.runstat = STAT_RUN_NSSTA;

  }else{
    return 0;
  }
  
  return 1;
}

int babild_stop(void){
  int ret;
  volatile int loop = 0;

  if(runinfo.runstat == STAT_RUN_IDLE){
    return 0;
  }

  ret = escommand(ES_RUN_STOP);

  while(runinfo.runstat != STAT_RUN_IDLE){
    usleep(1000);
    printf("wait stop %d\n", loop);
    loop++;
    if(loop > 3000){
      break;
    }
  }
  if(loop > 3000){
    ret = 0;
  }

  return ret;
}

int babild_get_esconfig(void){
  char cmd[1024] = {0};
  
  sprintf(cmd, "%d", esefn);
  cj_getesconfig(cmd);

  return 0;
}

int babild_set_eserhost(void){
  char cmd[1024];

  sprintf(cmd, "%d", esefn);
  cj_getesconfig(cmd);
  strcpy(orgeshost, efrc.erhost);
  sprintf(cmd, "%d host localhost", esefn);
  cj_setesconfig(cmd);

  return 0;
}

int babild_resotre_eserhost(void){
  char cmd[1024];

  sprintf(cmd, "%d host %s", esefn, orgeshost);
  cj_setesconfig(cmd);

  return 0;
}

char* babild_data(void){
  return data;
}

int babild_dcopy(char *buff, int max){
  int hd = 0;
  int csz = 0;
  int ret = 0;

  pthread_mutex_lock(&datamutex);
  memcpy((char *)&hd, data, 4);
  csz = (hd & 0x003fffff) * 2;

  if(csz > max){
    ret = -1;
  }else{
    memcpy(buff, data, csz);
    ret = csz;
  }
  pthread_mutex_unlock(&datamutex);

  return ret;
}
