#include "bbjsons.h"

#include <stdio.h>
#include <string.h>

static int cidx=0, lidx=0;
static char safeout[1024];

char *bbjsons_safechar(char *in){
  int len, i, max, idx=0;
  
  len = strlen(in);
  if(len > sizeof(safeout) - 2){
    len = sizeof(safeout) - 2;
  }
  max = sizeof(safeout) - 2;

  for(i=0;i<len;i++){
    switch(in[i]){
    case '"':
      safeout[idx] = '\\';
      idx ++;
      safeout[idx] = in[i];
      idx ++;
      break;
    case '\\':
      safeout[idx] = '\\';
      idx ++;
      safeout[idx] = in[i];
      idx ++;
      break;
    case '/':
      safeout[idx] = '\\';
      idx ++;
      safeout[idx] = in[i];
      idx ++;
      break;
    case '\n':
      safeout[idx] = '\\';
      idx ++;
      safeout[idx] = 'n';
      idx ++;
      break;
    case '\r':
      safeout[idx] = '\\';
      idx ++;
      safeout[idx] = 'r';
      idx ++;
      break;
    case '\t':
      safeout[idx] = ' ';
      idx ++;
      break;
    case '\b':
      safeout[idx] = ' ';
      idx ++;
      break;
    case '\f':
      safeout[idx] = ' ';
      idx ++;
      break;
    default:
      safeout[idx] = in[i];
      idx ++;
      break;
    }
    
    if(idx >= max){
      break;
    }
  }
  safeout[idx] = 0;

  return safeout;
}

int putidxs(char *b){
  int i;
  int ret = 0;
  for(i=0;i<cidx;i++){
    ret += sprintf(b+ret, "  ");
  }

  return ret;
}

int bbjsons_begin(char *b){
  cidx = 0;
  lidx = -1;
  return bbjsons_begin_obj(b, NULL);
}

int bbjsons_begin_obj(char *b, char *key){
  int ret = 0;
  if(cidx <= lidx){
    ret += sprintf(b+ret, ",\n");
  }else if(lidx != -1){
    ret += sprintf(b+ret, "\n");
  }
  lidx = cidx;

  ret += putidxs(b+ret);
  if(!key){
    ret += sprintf(b+ret, "{");
  }else{
    ret += sprintf(b+ret, "\"%s\": {", key);
  }
  cidx ++;

  return ret;
}

int bbjsons_charobj_single(char *b, char *key, char *val){
  int ret = 0;
  if(cidx <= lidx){
    ret += sprintf(b+ret, ",\n");
  }else{
    ret += sprintf(b+ret, "\n");
    lidx = cidx;
  }
  ret += putidxs(b+ret);
  if(key){
    ret += sprintf(b+ret, "\"%s\": ", key);
  }
  if(val){
    ret += sprintf(b+ret, "\"%s\"", bbjsons_safechar(val));
  }
  return ret;
}

int bbjsons_charobj(char *b, char *key, char *val){
  int ret = 0;

  if(cidx == lidx){
    ret += sprintf(b+ret, ",\n");
  }else{
    ret += sprintf(b+ret, "\n");
    lidx = cidx;
  }
  ret += putidxs(b+ret);
  if(key){
    ret += sprintf(b+ret, "\"%s\": ", key);
  }
  if(val){
    ret += sprintf(b+ret, "\"%s\"", bbjsons_safechar(val));
  }
  
  return ret;
}

int bbjsons_intobj_single(char *b, char *key, int val){
  int ret = 0;

  if(cidx <= lidx){
    ret += sprintf(b+ret, ",\n");
  }else{
    ret += sprintf(b+ret, "\n");
    lidx = cidx;
  }
  ret += putidxs(b+ret);
  if(key){
    ret += sprintf(b+ret, "\"%s\": ", key);
  }
  ret += sprintf(b+ret, "%d", val);

  return ret;
}

int bbjsons_intobj(char *b, char *key, int val){
  int ret = 0;

  if(cidx == lidx){
    ret += sprintf(b+ret, ",\n");
  }else{
    ret += sprintf(b+ret, "\n");
    lidx = cidx;
  }
  ret += putidxs(b+ret);
  if(key){
    ret += sprintf(b+ret, "\"%s\": ", key);
  }
  ret += sprintf(b+ret, "%d", val);

  return ret;
}

int bbjsons_uintobj(char *b, char *key, unsigned int val){
  int ret = 0;

  if(cidx == lidx){
    ret += sprintf(b+ret, ",\n");
  }else{
    ret += sprintf(b+ret, "\n");
    lidx = cidx;
  }
  ret += putidxs(b+ret);
  if(key){
    ret += sprintf(b+ret, "\"%s\": ", key);
  }
  ret += sprintf(b+ret, "%u", val);

  return ret;
}


int bbjsons_lluintobj(char *b, char *key, unsigned long long int val){
  int ret = 0;

  if(cidx == lidx){
    ret += sprintf(b+ret, ",\n");
  }else{
    ret += sprintf(b+ret, "\n");
    lidx = cidx;
  }
  ret += putidxs(b+ret);
  if(key){
    ret += sprintf(b+ret, "\"%s\": ", key);
  }
  ret += sprintf(b+ret, "%Lu", val);

  return ret;
}

int bbjsons_floatobj(char *b, char *key, float val){
  int ret = 0;

  if(cidx == lidx){
    ret += sprintf(b+ret, ",\n");
  }else{
    ret += sprintf(b+ret, "\n");
    lidx = cidx;
  }
  ret += putidxs(b+ret);
  if(key){
    ret += sprintf(b+ret, "\"%s\": ", key);
  }
  ret += sprintf(b+ret, "%f", val);

  return ret;
}


int bbjsons_end_obj(char *b){
  int ret = 0;

  ret += sprintf(b+ret, "\n");
  cidx --;
  ret += putidxs(b+ret);
  ret += sprintf(b+ret, "}");

  return ret;
}

int bbjsons_begin_array(char *b, char *key){
  int ret = 0;

  if(cidx <= lidx){
    ret += sprintf(b+ret, ",\n");
  }else{
    ret += sprintf(b+ret, "\n");
  }
  lidx = cidx;
  ret += putidxs(b+ret);
  if(key){
    ret += sprintf(b+ret, "\"%s\": ", key);
  }
  ret += sprintf(b+ret, "[");
  lidx--;

  return ret;
}

int bbjsons_end_array(char *b){
  int ret = 0;

  if(lidx < cidx){
    lidx = cidx;
    ret += sprintf(b+ret, "\n");
  }
  ret += putidxs(b+ret);
  ret += sprintf(b+ret, "]");

  return ret;
}

int bbjsons_end(char *b){
  int ret = 0;

  ret += bbjsons_end_obj(b);
  cidx = 0 ;
  lidx = 0;
  ret += sprintf(b+ret, "\n");

  return ret;
}

int bbjsons_ushortarray(char *b, char *key, unsigned short *data, int sz){
  int ret = 0;
  int i;

  if(cidx == lidx){
    ret += sprintf(b+ret, ",\n");
  }else{
    ret += sprintf(b+ret, "\n");
    lidx = cidx;
  }
  ret += putidxs(b+ret);
  if(key){
    ret += sprintf(b+ret, "\"%s\": ", key);
  }

  ret += sprintf(b+ret, "[ ");

  for(i=0;i<sz;i++){
    if(i!=0){
      ret += sprintf(b+ret, ",");
    }
    ret += sprintf(b+ret, "%u", data[i]);
  }
  ret += sprintf(b+ret, " ]");

  return ret;
}

int bbjsons_shortarray(char *b, char *key, short *data, int sz){
  int ret = 0;
  int i;

  if(cidx == lidx){
    ret += sprintf(b+ret, ",\n");
  }else{
    ret += sprintf(b+ret, "\n");
    lidx = cidx;
  }
  ret += putidxs(b+ret);
  if(key){
    ret += sprintf(b+ret, "\"%s\": ", key);
  }

  ret += sprintf(b+ret, "[ ");

  for(i=0;i<sz;i++){
    if(i!=0){
      ret += sprintf(b+ret, ",");
    }
    ret += sprintf(b+ret, "%d", data[i]);
  }
  ret += sprintf(b+ret, " ]");

  return ret;
}

int bbjsons_uintarray(char *b, char *key, unsigned int *data, int sz){
  int ret = 0;
  int i;

  if(cidx == lidx){
    ret += sprintf(b+ret, ",\n");
  }else{
    ret += sprintf(b+ret, "\n");
    lidx = cidx;
  }
  ret += putidxs(b+ret);
  if(key){
    ret += sprintf(b+ret, "\"%s\": ", key);
  }

  ret += sprintf(b+ret, "[ ");

  for(i=0;i<sz;i++){
    if(i!=0){
      ret += sprintf(b+ret, ",");
    }
    ret += sprintf(b+ret, "%u", data[i]);
  }
  ret += sprintf(b+ret, " ]");

  return ret;
}

int bbjsons_intarray(char *b, char *key, int *data, int sz){
  int ret = 0;
  int i;

  if(cidx == lidx){
    ret += sprintf(b+ret, ",\n");
  }else{
    ret += sprintf(b+ret, "\n");
    lidx = cidx;
  }
  ret += putidxs(b+ret);
  if(key){
    ret += sprintf(b+ret, "\"%s\": ", key);
  }

  ret += sprintf(b+ret, "[ ");

  for(i=0;i<sz;i++){
    if(i!=0){
      ret += sprintf(b+ret, ",");
    }
    ret += sprintf(b+ret, "%d", data[i]);
  }
  ret += sprintf(b+ret, " ]");

  return ret;
}
