#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "bbjsonb.h"
#include "bbjsons.h"

static int idx = 0;
static char *buff;

void bbjsonb_init(void){
  buff = malloc(1024*1024);
  buff[0] = 0;
}

char *bbjsonb_buff(){
  return buff;
}

int bbjsonb_len(){
  return strlen(buff);
}

int bbjsonb_begin(){
  //memset(buff, 0, sizeof(buff));
  idx = bbjsons_begin(buff);
  return idx;
}

int bbjsonb_charobj(char *key, char *val){
  idx += bbjsons_charobj(buff+idx, key, val);
  return idx;
}

int bbjsonb_charobj_single(char *key, char *val){
  idx += bbjsons_charobj_single(buff+idx, key, val);
  return idx;
}

int bbjsonb_intobj(char *key, int val){
  idx += bbjsons_intobj(buff+idx, key, val);
  return idx;
}

int bbjsonb_uintobj(char *key, unsigned int val){
  idx += bbjsons_uintobj(buff+idx, key, val);
  return idx;
}

int bbjsonb_intobj_single(char *key, int val){
  idx += bbjsons_intobj_single(buff+idx, key, val);
  return idx;
}

int bbjsonb_lluintobj(char *key, unsigned long long int val){
  idx += bbjsons_lluintobj(buff+idx, key, val);
  return idx;
}

int bbjsonb_floatobj(char *key, float val){
  idx += bbjsons_floatobj(buff+idx, key, val);
  return idx;
}

int bbjsonb_begin_obj(char *key){
  idx += bbjsons_begin_obj(buff+idx, key);
  return idx;
}

int bbjsonb_end_obj(){
  idx += bbjsons_end_obj(buff+idx);
  return idx;
}

int bbjsonb_begin_array(char *key){
  idx += bbjsons_begin_array(buff+idx, key);
  return idx;
}

int bbjsonb_end_array(){
  idx += bbjsons_end_array(buff+idx);
  return idx;
}

int bbjsonb_end(){
  idx += bbjsons_end(buff+idx);
  return idx;
}

int bbjsonb_ushortarray(char *key, unsigned short *data, int sz){
  idx += bbjsons_ushortarray(buff+idx, key, data, sz);
  return idx;
}

int bbjsonb_uintarray(char *key, unsigned int *data, int sz){
  idx += bbjsons_uintarray(buff+idx, key, data, sz);
  return idx;
}

int bbjsonb_shortarray(char *key, short *data, int sz){
  idx += bbjsons_shortarray(buff+idx, key, data, sz);
  return idx;
}

int bbjsonb_intarray(char *key, int *data, int sz){
  idx += bbjsons_intarray(buff+idx, key, data, sz);
  return idx;
}

