#define MKSEGID(device,focal,detector,module) ((((device<<6 | focal) << 6) | detector)<<8 | module)

// Device or ExpGroup   0--63
#define BIGRIPS    0
#define ZeroDegree 1
#define SAMURAI    2
#define R3         5
#define RIPS       10
#define SHARAQ     11
#define ESPRI      12
#define HIMAC      15
#define DALI       20
#define GAMMAGR    21
#define BETAGR     22
#define RADIIGR    23
#define SAMURAIGR  24
#define USERGR     57
#define DAQ        58  // for special case

// Focal plane  0--63
#define F1   1
#define F2   2
#define F3   3
#define F4   4
#define F5   5
#define F6   6
#define F7   7
#define F8   8
#define F9   9
#define F10  10
#define F11  11
#define F12  12
#define F13  13
/* 20--21, 62 for SHARAQ */
#define FDAQ 58       // for special case 
#define B3F  63

// For SHARAQ
#define H7  7
#define H8  8
#define H9  9
#define H10 10
#define S0  20
#define S1  21
#define S2  22
#define SHB3F 62

// Detector  0--63
#define SCALER   63
#define ISCALER  62
#define B2SCALER 61
#define TS       60
#define DTMON    59
#define DDAQ     58       // for special case 
#define ICGAS    57
#define RF       50
#define RF2      51
#define PPACQ    0
#define PPACT    1
#define PLAQ     2
#define PLAT     3
#define ICE      4
#define ICT      5
#define SSDE     6
#define SSDT     7
#define ISGEA    8
#define ISGET    9
#define COIN    10
#define NAIE    11
#define TOTE    11
#define PILEUP  12
#define STOPPLA 13
#define PLA2T   14
#define PLA2Q   15
#define PLACFD  41
#define PLALVL  42
#define PLALVH  43
#define PLA2CFD 44
#define PLA2LVL 45
#define PLA2LVH 46
#define NAIT    16
#define TOTQ    17
#define LABRA   18
#define LABRT   19
// 20
#define DALIA   21
#define DALIT   22
#define BETAA   23
#define BETAT   24
#define HIA     25
#define CLOVERA 26
#define CLOVERT 27
#define VETOA   28
#define VETOT   29
#define TECHNO  30
//
// For SHARAQ
#define SHBLD     31
#define SHCRDC    32
#define SHCRDCA   33
#define SHCRDCC   34
#define SHCRDCT1  35
#define SHCRDCT2  36
#define SHCRDCA2  37
#define SHCRDCA3  38

// For Must2
//#define MUST2DET 50
#define PLAYOBI  50
#define MINOS 53

//// for gamma11
//#define GAMMAPLAT 52

// For BigRIPS development
#define PLATC     60

// Module  0--255
#define C16        0
#define C24        1
#define AD413AC    2    // AD413A + w/o Zero supp.   (CAMAC read)
#define AD413ACZ   3    // AD413A + Zero suppression (CAMAC read)
#define AD413AM    4    // AD413A + w/o Zero supp.   + Memory
#define AD413A     5    // AD413A + Zero suppression + Memory
#define AD413AMZ   5    // AD413A + Zero suppression + Memory
#define L3377      6    // LeCroy 3377 Double word (CAMAC read)
#define L3377CW    6    // LeCroy 3377 Double word (CAMAC read)
#define L3377CS    7    // LeCroy 3377 Single word (CAMAC read)
#define P7166      9    // Philips 7166 + w/o Zero supp.
#define P716X      9    // Philips 7166 + w/o Zero supp.
#define P716XZ    10    // Philips 7166 + Zero suppression
//#define CTM405    11  // conflict with L4300BC
#define L3377MW   16    // LeCroy 3377 Double word   + Memory
#define L3377MS   17    // LeCroy 3377 Single word   + Memory
#define L4300BC   11    // LeCroy 4300B + w/o Zero supp.   (CAMAC read)
#define L4300BCZ  12    // LeCroy 4300B + Zero suppression (CAMAC read)
#define L4300BM   13    // LeCroy 4300B + w/o Zero supp.   + Memory
#define L4300BMZ  14    // LeCroy 4300B + Zero suppression + Memory
#define CTS105    15
#define RIPV100   18
#define MDPP16    19
#define V830      20
#define V775      21
#define V785      21
#define V792      21
#define V550      22
#define V767      23
#define V1190     24
#define V1190A    24
#define V1190B    24
#define V1290     25
#define V1190C    26
#define V7XXBIGEND 27
#define NEULANDTS  28
#define DSP       29
#define TC842     30
#define A3100     31
#define MADC32    32    // Mesytech ADC
#define MQDC32    33    // conflict with MQDC32
//#define TC890     33    // conflict with MQDC32
#define MTDC32    34    // Mesytech TDC
#define VMEEASIROC 35
#define AMTTDC    36
//#define SIS3820   36  // conflict with AMTTDC
#define SIS3350   38 
#define LUPOIO      41
#define LUPOTS      42
#define LUPOMTS     43  // for dead time monitor
#define RICHADCM    44
#define MIRAPSA     48
#define MIRAQDC     49
#define MUST2VXI    50
#define MINOS       53
#define TACQUILA    54
#define HINP        56
#define RDC         56
#define MDAQ        58  // for special case
#define V1730       60
//#define V1730ZLE    61 // conflict with RAINER
#define RAINER      61 
#define VETAR       62

// ScalerID 0--65535
#define DTMONSCALER    1
#define CCNET01SCALER 21
#define CCNET02SCALER 22
#define CCNET03SCALER 23
#define CCNET04SCALER 24
#define CCNET05SCALER 25
#define CCNET06SCALER 26
#define CCNET07SCALER 27
#define CCNET08SCALER 28
#define F7DAQSCALER   31
#define SSMSCALER     33
#define F11DAQSCALER  34
#define F11GESCALER   35
#define F3DAQSCALER   36
#define GGDAQ01SCALER 41
//
#define SHSSMSCALER   100
