/* devtool/chksumridf.c
 * 
 * last modified : 07/03/30 14:59:31 
 * 
 * Hidetada Baba (RIKEN)
 * baba@ribf.riken.jp
 *
 * Check RIDF file
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <bi-config.h>
#include <bi-common.h>
#include <ridf.h>
#include <bbcpri.h>

#define MAXBUFFSIZE 100000

int main(int argc, char *argv[]){
  RIDFHD hd;
  RIDFRHD rhd;
  unsigned short buff[MAXBUFFSIZE];
  FILE *fd;
  unsigned int blkn;
  unsigned int blksz, sumsz;
  char ofile[256]={0};


  if(argc != 2){
    printf("mkevtfp FILENAME\n");
    exit(0);
  }

  if((fd = fopen(argv[1], "r")) == NULL){
    printf("Can't open %s\n", argv[1]);
    exit(1);
  }
  sprintf(ofile, "%s.fp", argv[1]);
  
  blkn = -1;
  memset(buff, 0, sizeof(buff));
  blksz = 0;
  sumsz = 0;
  

  while(fread((char *)&hd, sizeof(hd), 1, fd) == 1){
    rhd = ridf_dechd(hd);

    switch(rhd.classid){
    case RIDF_EF_BLOCK:
    case RIDF_EA_BLOCK:
    case RIDF_EAEF_BLOCK:
      if(blksz != sumsz){
	printf("blksz = %d / sumsz = %d\n", blksz, sumsz);
      }
      blksz = 0;
      sumsz = sizeof(hd)/WORDSIZE;
      blksz = rhd.blksize;
      blkn++;
      break;
    case RIDF_EVENT:
      fread((char *)buff, WORDSIZE, rhd.blksize - sizeof(hd)/WORDSIZE, fd);
      printf("%d blksize\n", rhd.blksize);
      sumsz += rhd.blksize;
      break;
    default:
      sumsz += rhd.blksize;
      fread((char *)buff, WORDSIZE, rhd.blksize - sizeof(hd)/WORDSIZE, fd);
      break;
    }
  }

  fclose(fd);

  return 0;
}
