/* devtool/extsegridf.c
 * 
 * last modified : 17/02/13 10:59:07 
 * 
 * Hidetada Baba (RIKEN)
 * baba@ribf.riken.jp
 *
 * RIDF extract segment
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/types.h>

#include <bi-config.h>
#include <bi-common.h>
#include <ridf.h>

#include <bbzfile.h>

#define MAXSEGID  200

int hds, evthds, seghds;
unsigned short *ibuff;
static bgFile *ifd;
static FILE *ofd = {NULL};
int seglist = 0;
int efnlist = 0;

int main(int argc, char *argv[]){
  RIDFHD hd;
  RIDFRHD rhd;
  RIDFHDEVT evthd;
  RIDFHDSEG seghd;
  int evtn;
  unsigned long long int ts;
  unsigned int segid, segdatas;

  if(argc < 4){
    printf("extsegridf efn segid INFILE OUTFILE\n");
    exit(0);
  }

  seglist = strtol(argv[2], NULL, 0);
  efnlist = strtol(argv[1], NULL, 0);
  
  // Input File
  if((ifd = bgropen(argv[3])) == NULL){
    printf("Can't open input file %s\n", argv[3]);
    exit(1);
  }
  if(ifd){
    if(ifd->gfd){
      printf("GZIPPED RIDF\n");
    }
  }
  
  ofd = fopen(argv[4], "w");

  printf("EFN%3d : 0x%08x\n", efnlist, seglist);
  printf("IN     : %s\n", argv[3]);
  printf("OUT    : %s\n", argv[4]);

  printf("\n");

  ibuff = malloc(EB_EFBLOCK_SIZE);
  memset(ibuff, 0, EB_EFBLOCK_SIZE);
  hds = sizeof(hd)/WORDSIZE;
  evthds = sizeof(evthd)/WORDSIZE;
  seghds = sizeof(seghd)/WORDSIZE;

  //while(fread((char *)&hd, sizeof(hd), 1, ifd) == 1){
  while(bgread(ifd, (char *)&hd, sizeof(hd)) > 0){
    rhd = ridf_dechd(hd);
    switch(rhd.classid){
    case RIDF_EF_BLOCK:
    case RIDF_EA_BLOCK:
    case RIDF_EAEF_BLOCK:
      break;
    case RIDF_EVENT:
      bgread(ifd, (char *)&evtn, sizeof(evtn));
      //fread((char *)&evtn, sizeof(evtn), 1, ifd);
      break;
    case RIDF_EVENT_TS:
      bgread(ifd, (char *)&evtn, sizeof(evtn));
      bgread(ifd, (char *)&ts, sizeof(ts));
      //fread((char *)&evtn, sizeof(evtn), 1, ifd);
      //fread((char *)&ts, sizeof(ts), 1, ifd);
      break;
    case RIDF_SEGMENT:
      bgread(ifd, (char *)&segid, sizeof(segid));
      //fread((char *)&segid, sizeof(segid), 1, ifd);

      segdatas = rhd.blksize-(sizeof(hd)+sizeof(segid))/WORDSIZE;
      bgread(ifd, (char *)ibuff, segdatas*2);
      //fread((char *)ibuff, 2, segdatas, ifd);

      if(rhd.efn == efnlist && segid == seglist){
	fwrite((char *)ibuff, 2, segdatas, ofd);
      }

      break;
    default:
      segdatas = rhd.blksize-sizeof(hd)/WORDSIZE;
      bgread(ifd, (char *)ibuff, segdatas*2);
      //fread((char *)ibuff, 2, segdatas, ifd);
      break;
    }
  }

  printf("\n Last event number = %d\n", evtn);

  if(ofd){
    fclose(ofd);
  }

  bgclose(ifd);
  free(ibuff);

  return 0;
}
