/* sis3300/1.h */


/* Register */
#define SIS3300_CTRL_STAT                  0x00
#define SIS3300_MODID                      0x04
#define SIS3300_IRQ_CONF                   0x08
#define SIS3300_IRQ_CTRL                   0x0c
#define SIS3300_ACQ_CTRL                   0x10
#define SIS3300_START_DELAY                0x14
#define SIS3300_STOP_DELAY                 0x18
#define SIS3300_TIMESTAMP_PREDIVIDER       0x1c
#define SIS3300_KEY_RESET                  0x20
#define SIS3300_KEY_START                  0x30
#define SIS3300_KEY_STOP                   0x34
#define SIS3300_KEY_START_AUTO_BANK_SWITCH 0x40
#define SIS3300_KEY_STOP_AUTO_BANK_SWITCH  0x44
#define SIS3300_KEY_BANK1_FULL_FLAG        0x48
#define SIS3300_KEY_BANK2_FULL_FLAG        0x4c
#define SIS3300_ONE_WIRE                   0x60
#define SIS3300_EVENT_TIMESTAMP_DIR_BANK1  0x1000
#define SIS3300_EVENT_TIMESTAMP_DIR_BANK2  0x2000
#define SIS3300_EVENT_CONFIG_ALL_ADC       0x100000
#define SIS3300_EVENT_CONFIG_ADC12         0x200000
#define SIS3300_EVENT_CONFIG_ADC34         0x280000
#define SIS3300_EVENT_CONFIG_ADC56         0x300000
#define SIS3300_EVENT_CONFIG_ADC78         0x380000
#define SIS3300_TRIGGER_THRESHOLD_ALL_ADC  0x100004
#define SIS3300_TRIGGER_THRESHOLD_ADC12    0x200004
#define SIS3300_TRIGGER_THRESHOLD_ADC34    0x280004
#define SIS3300_TRIGGER_THRESHOLD_ADC56    0x300004
#define SIS3300_TRIGGER_THRESHOLD_ADC78    0x380004

#define SIS3300_TRIGGER_EVT_DIR_BANK1      0x101000

#define SIS3300_ADC12                      0
#define SIS3300_ADC34                      1
#define SIS3300_ADC56                      2
#define SIS3300_ADC78                      3
#define SIS3300_BANKSIZE                   0x080000
#define SIS3300_MEMBASE_BANK1              0x400000
#define SIS3300_ORBIT_S                    0x4000
#define SIS3300_USRBIT_S                   0x8000

#define SIS3300_MEMBASE_BANK1_ADC12        0x400000
#define SIS3300_MEMBASE_BANK1_ADC34        0x480000
#define SIS3300_MEMBASE_BANK1_ADC56        0x500000
#define SIS3300_MEMBASE_BANK1_ADC78        0x580000
#define SIS3300_MEMBASE_BANK2_ADC12        0x600000
#define SIS3300_MEMBASE_BANK2_ADC34        0x680000
#define SIS3300_MEMBASE_BANK2_ADC56        0x700000
#define SIS3300_MEMBASE_BANK2_ADC78        0x780000

#define SIS3300_EVT_DIR_BANK1              0x201000
#define SIS3300_EVT_DIR_OFF                0x080000

#define SIS3300_ADDR_CNT_BANK1             0x200008
#define SIS3300_ADDR_CNT_OFF               0x080000

/* Bit */
// Acquisition mode
#define SIS3300_ACQ_EN_SM_CL_M1   0x00000001
#define SIS3300_ACQ_EN_SM_CL_M2   0x00000002
#define SIS3300_ACQ_EN_SWITCH     0x00000004
#define SIS3300_ACQ_EN_RESERVED   0x00000008
#define SIS3300_ACQ_EN_AUTOSTART  0x00000010
#define SIS3300_ACQ_EN_MULTI_EVT  0x00000020
#define SIS3300_ACQ_EN_START_DL   0x00000040
#define SIS3300_ACQ_EN_STOP_DL    0x00000080
#define SIS3300_ACQ_EN_LEMO_SSL   0x00000100
#define SIS3300_ACQ_EN_P2_SSL     0x00000200
#define SIS3300_ACQ_EN_GATE       0x00000400
#define SIS3300_ACQ_EN_EXT_CLK_RND 0x00000800
#define SIS3300_ACQ_EN_CLK_S0     0x00001000
#define SIS3300_ACQ_EN_CLK_S1     0x00002000
#define SIS3300_ACQ_EN_CLK_S2     0x00004000
#define SIS3300_ACQ_EN_MULTI_PLX  0x00008000
#define SIS3300_ACQ_DIS_SM_CL_M1  0x00010000
#define SIS3300_ACQ_DIS_SM_CL_M2  0x00020000
#define SIS3300_ACQ_DIS_SWITCH    0x00040000
#define SIS3300_ACQ_DIS_RESERVED  0x00080000
#define SIS3300_ACQ_DIS_AUTOSTART 0x00100000
#define SIS3300_ACQ_DIS_MULTI_EVT 0x00200000
#define SIS3300_ACQ_DIS_START_DL  0x00400000
#define SIS3300_ACQ_DIS_STOP_DL   0x00800000
#define SIS3300_ACQ_DIS_LEMO_SSL  0x01000000
#define SIS3300_ACQ_DIS_P2_SSL    0x02000000
#define SIS3300_ACQ_DIS_GATE      0x04000000
#define SIS3300_ACQ_DIS_EXT_CLK_RND 0x08000000
#define SIS3300_ACQ_CLR_CLK_S0    0x10000000
#define SIS3300_ACQ_CLR_CLK_S1    0x20000000
#define SIS3300_ACQ_CLR_CLK_S2    0x40000000
#define SIS3300_ACQ_CLR_MULTI_PLX 0x80000000

#define SIS3300_ACQ_EN_EXT_CLK    0x00006000
#define SIS3300_ACQ_DIS_EXT_CLK   0x60000000

// Event configuration
#define SIS3300_EVT_EN_WRAP       0x00000008
#define SIS3300_EVT_EN_GATE_CHAIN 0x00000010

#define ON   1
#define OFF  0

