/*
 * message.c : Network CAMAC library for PCI / pipeline CAMAC controller
 * Copyright 2003 (C) 2003 Yoshiji Yasu <Yoshiji.YASU@kek.jp>.
 *
 * version: 0.1  25-JUN-2003, born
 *          0.2  11-AUG-2003, beta release
 */

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>        /*  socket types              */

int readMessage(int fd, char *ptr, int nbytes) {
  int  nleft, nread;

  nleft = nbytes;
  while ( nleft > 0) {
    nread = read(fd, ptr, nleft);
    if( nread < 0 ) {
      printf("nread < 0\n");
      return nread;
      //    } else if (nread == 0) {
      //      printf("nread == 0\n");
      //      break;
    }
    nleft -= nread;
    ptr   += nread;
  }
  if( nleft ) {
#ifdef DEBUG
    printf("readMessage: NG\n");
#endif
    return -1;
  } else {
#ifdef DEBUG
    printf("readMessage: OK\n");
#endif
    return 0;
  }
}

int writeMessage(int fd, char *ptr, int nbytes) {
  int  nleft, nwritten;

  nleft  = nbytes;
  while ( nleft > 0 ) {
    nwritten = write(fd, ptr, nleft);
    if ( nwritten <= 0) 
      break;
    nleft -= nwritten;
    ptr   += nwritten;
  }
  if( nleft ) {
#ifdef DEBUG
    printf("writeMessage: NG\n");
#endif
    return -1;
  } else {
#ifdef DEBUG
    printf("writeMessage: OK\n");
#endif
    return 0;
  }
}
