#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <signal.h>

#include "command.h"
#include "pcc.h"

#define TIMEOUT 60000
#define FRAME_LEN 100
#define BUF_LEN FRAME_LEN*2

static int     shmid;
static CRASHM *shmp;
static int     semid;
static struct
       sembuf  semops[1];

#include "ccnet_int.c"

int main()
{
    int fd,i,j;
    /*    int data,q,x,lam_pattern; */
    int len,len1,status,actual_length,length;
    int commentlen; 
    int cmdbuf[BUF_LEN+2],rplybuf[BUF_LEN+2];
    int clrbuf[BUF_LEN+2];
    unsigned short databuf[BUF_LEN+2];
    unsigned short data;
    if ((shmid = shmget(SHMKEY, sizeof(CRASHM), IPC_CREAT|0600)) == -1)
	{puts("# Cannot create shared memory"); exit(2);}
    if ((semid = semget(SEMKEY, 1             , IPC_CREAT|0600)) == -1)
	{puts("# Cannot create semaphore"); exit(2);}
    shmp = (CRASHM *)shmat(shmid, 0, 0);

    if ((fd= cam_open()) == -1 ){
      printf("cam_open error\n");
      exit(0);
    }
    length = 100;
    cam_gen_init(length,cmdbuf);
    cam_gen_init(length,rplybuf);
    cam_gen_init(length,clrbuf);
    ccnet_int(fd,cmdbuf,&len);
    ccnet_clr(clrbuf,&len1);

    for (;;){
	  while(shmp->acquire == 1){
	    ccnet_inton(fd);
	    status = cam_exec(fd,cmdbuf,rplybuf);
	    extract_data(rplybuf,len,&actual_length,databuf);
#if defined(DEBUG)	    
	      for (j = 0; j < actual_length; j++) 
		printf("data %d %x\n",j,databuf[j]);
	      fflush(stdout);
#endif
	    if (shmp->rawdat >0){
	      if ((shmp->rwcnt%MAX_EV)==0){
		data = DELIM;
		status = write(shmp->rawdat,&data,sizeof(short));
		/* printf("evnt %d write DELIM\n",shmp->rwcnt); */
	      }
	      status = write(shmp->rawdat,&databuf,
			     actual_length*sizeof(short));
	    }
	    shmp->rwcnt++;
	    for (j = 0; j < actual_length; j++)
	      /* copy data for on-line analyzer */
		shmp->buff[(shmp->wp++)%MAX_BUF] = databuf[j];
	    if (semctl(semid, 0, GETNCNT, 0)) {
	      /* notify data is ready */
		  semops[0].sem_num =  0;
		  semops[0].sem_op  =  1;
		  semops[0].sem_flg =  IPC_NOWAIT;
		  semop(semid, semops, 1);
	    }
	    status = cam_exec(fd,clrbuf,rplybuf);
#if defined(DEBUG)
	    printf("loop: %d\r",shmp->rwcnt);
#endif
	    fflush(stdout);
	    ccnet_intoff(fd);
	  }
	  if (shmp->acquire == 0){
	    if (shmp->path[0]&&shmp->comment[0]){
	      shmp->rawdat = open(shmp->path,O_RDWR|O_CREAT,0644);
	      shmp->path[0] = 0;
	      commentlen = strlen(shmp->comment) + 4;
	      write(shmp->rawdat, &commentlen, sizeof(short));
	      write(shmp->rawdat, shmp->comment, commentlen);
	    }
	    if (shmp->fclose){
	      data = 0xffff;
	      if (shmp->rawdat){
		write(shmp->rawdat,&data,2); /* write EOF */
		close(shmp->rawdat);shmp->rawdat = 0;
	      }
	    }
	  }
    }
}
