#define MAX_BUF 1024

#define SHMKEY 1048581
#define SEMKEY 1048582

#define MAX_EV 1024
#define DELIM 0xcc77

#if defined(__ANANET__)
#define ANA_PORT (2004)
#define ANA_HOST "yayoi"
#endif

typedef struct {
  int      acquire;              /* status of data acquisition       */
  int      fclose;               /* status of data acquisition       */
  int      rawdat;               /* file descriptor of raw data      */
  char     path[256];            /* file   name     of raw data      */
  char     comment[256];         /* comment to be written at header  */
  unsigned long  rwcnt;          /* written event numbers            */
  unsigned long  ancnt, ercnt;   /* analyzed & error event numbers   */
  unsigned int   rp,wp;          /* write- & read-pointers           */
  unsigned short buff[MAX_BUF];  /* data buffer for on-line analyzer */
} CRASHM;

#if defined(COMMAND)

#define CMD_INITIALIZE  1
#define CMD_RESET       2
#define CMD_START       3
#define CMD_STOP        4
#define CMD_OPEN        5
#define CMD_CLOSE       6
#define CMD_SCALER      7
#define CMD_COUNT       8
#define CMD_EXIT        9

int check_cmd(char *arg)
{
  const struct {char *name; int min, key; }
  cmd_table[] = {
    {"INITIALIZE",  1, CMD_INITIALIZE},
    {"RESET"     ,  1, CMD_RESET },
    {"START"     ,  3, CMD_START },
    {"STOP"      ,  3, CMD_STOP },
    {"OPEN"      ,  1, CMD_OPEN },
    {"CLOSE"     ,  2, CMD_CLOSE },
    {"SCALER"    ,  2, CMD_SCALER },
    {"COUNT"     ,  2, CMD_COUNT },
    {"EXIT"      ,  1, CMD_EXIT },
    {""          ,  0, 0 }
  };
  char s[256]; int i, n;
  while (*arg == ' ') arg++;
  for (n = 0; *arg != ' ' && *arg != 0; arg++)
    s[n++] = ((*arg >= 'a') ? *arg - ' ' : *arg); s[n] = 0;
  for (i = 0; cmd_table[i].key != 0; i++) {
    if (n >= cmd_table[i].min && n <= strlen(cmd_table[i].name))
      if (!strncmp(s, cmd_table[i].name, n)) return cmd_table[i].key;
  }
  return -1;
}
#endif
