#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "pcc.h"

#define TIMEOUT 0
#define COMMAND
#include "command.h"

static int shmid,semid;
static CRASHM *shmp;

static int     scaler_adr=0;
static int     scaler_ch =0;

#include "ccnet_int.c"

#define gets(s) (fgets(s,sizeof(s),stdin)?s[strlen(s)-1]=0,s:NULL)
main(){
  char s[256],l[256];
  int fd,i,j,len;
  int data,q,x,status;
  
  /* create shared memory for analysis */
  if ((shmid = shmget(SHMKEY, sizeof(CRASHM), IPC_CREAT|0600)) == -1)
      {puts("! Cannot create shared memory"); fflush(stdout); exit(2);}
  if ((semid = semget(SEMKEY, 1             , IPC_CREAT|0600)) == -1)
      {puts("! Cannot create semaphore"); fflush(stdout); exit(2);}
  shmp = (CRASHM *)shmat(shmid, 0, 0);
  shmp->acquire = 0;shmp->fclose = 0;
  shmp->rawdat = 0; shmp->path[0] = 0; shmp->comment[0] = 0;
  shmp->rwcnt = 0; shmp->ancnt = 0; shmp->ercnt = 0;
  shmp->rp = 0; shmp->wp = 0;

  while(gets(s)){
    switch (check_cmd(s)){
    case CMD_INITIALIZE:
      if ((fd = cam_open()) == -1){
	printf("cam_open error\n");
	exit(0);
      }
      crate_clear(fd);
      printf("<<CCNET OPEN>>\n");
      fflush(stdout);
      break;
    case CMD_RESET:
      cam_clear_fifo(fd);
      usleep(100000L);
      module_clear(fd);
      if (scaler_adr && scaler_ch) {
	status = cam_single_cc(fd,scaler_adr,0,9,&data,&q,&x);
      }
      shmp->rp = 0; shmp->wp = 0;
      shmp->rwcnt = 0; shmp->ancnt = 0; shmp->ercnt = 0;
      shmp->acquire = 0; shmp->fclose = 0;
      fflush(stdout);
      break;
    case CMD_START:
      printf("<< STARTED >>\n");
      ccnet_start(fd);
      shmp->acquire = 1;
      fflush(stdout);
      break;
    case CMD_STOP:
      shmp->acquire = 0;
      ccnet_stop(fd);
      printf("<< STOPPED >>\n");
      fflush(stdout);
      break;
    case CMD_OPEN:
      if (shmp->rawdat)
	{puts("# Close file before writing new one"); fflush(stdout); break;}
      gets(shmp->path);
      gets(shmp->comment);
      printf("<< OPEN >>\n");
      fflush(stdout);
      break;
    case CMD_CLOSE:
      shmp->fclose = 1;
      for (i = 0; i < 20; i++) {if (!shmp->rawdat) break; usleep(100000L);}
      shmp->fclose = 0; shmp->path[0] = 0;shmp->comment[0]=0;
      printf("<< CLOSED >>\n");
      fflush(stdout);
      break;
    case CMD_SCALER:
      if (scanf("%d %d\n", &scaler_adr, &scaler_ch) != 2) scaler_adr = 0;
      if ((scaler_adr > 24) | (scaler_adr < 0) |
          (scaler_ch  > 16) | (scaler_ch  < 0))
        {puts("# Invalid Parameter for \"SCALER\""); fflush(stdout);}
      break;
    case CMD_COUNT:
      puts("<< COUNT >>");
      printf("%ld %ld %ld\n",
              shmp->rwcnt, shmp->ancnt, shmp->ercnt);
      if (scaler_adr && scaler_ch) {
        printf("<< SCALER >>\n%d\n", scaler_ch);
        for (i = 0; i < scaler_ch; i++) {
		  status = cam_single_cc(fd,scaler_adr,i,0,&data,&q,&x);
          printf("%ld\n", data);
        }
      }
      fflush(stdout);
	  break;
    case CMD_EXIT:
#if  (defined(LAM_N) && defined(LAM_A))
	  status = cam_disable_lam(fd);
	  status = cam_single_cc(fd,LAM_N,LAM_A,24,&data,&q,&x);
#endif
	  printf("<<EXIT>>\n");
	goto EXIT;
      break;
    default:
      printf("# Illigal Command (%s).\n",s);
      fflush(stdout);
      break;
    }
  }
 EXIT:
  close(fd);
  shmdt((char *)shmp);
  shmctl(shmid, IPC_RMID, 0);
  semctl(semid, 0, IPC_RMID, 0);
  exit(0);
}
