/*
 * ccnet_server.c : Network CAMAC library for PCI / pipeline CAMAC controller
 * Copyright 2003 (C) 2003 Yoshiji Yasu <Yoshiji.YASU@kek.jp>.
 *
 * version: 0.1  25-JUN-2003, born
 *          0.2  11-AUG-2003, beta release
 *          0.4  07-NOV-2003, add NODELAY socket option
 *          0.5  08-JAN-2004, change algorithm of error exit.
 *          0.6  12-JAN-2004, add REUSEADDR socket option
 *                            and change algorithm of error handling
 */

#include <sys/socket.h>       /*  socket definitions        */
#include <sys/types.h>        /*  socket types              */
#include <arpa/inet.h>        /*  inet (3) funtions         */
#include <unistd.h>           /*  misc. UNIX functions      */
#include <stdlib.h>
#include <stdio.h>
#include <netinet/tcp.h>
#include "ccnet.h"
#include "pcc.h"

int main(int argc, char *argv[]) {
    int       list_s;                /*  listening socket          */
    int       conn_s;                /*  connection socket         */
    short int port;                  /*  port number               */
    struct    sockaddr_in servaddr;  /*  socket address structure  */
    int       rcvbuf[(HEADER_SIZE+MAX_BUFFER_SIZE)/4]; /*  receive buffer */
    int       sndbuf[(HEADER_SIZE+MAX_BUFFER_SIZE)/4]; /*  send buffer    */
    int       sndlen, rcvlen, status;
    int       i, count;
    int       pid;
#ifdef NODELAY_OPTION
    int option = 1;
#endif

    if ( (list_s = socket(AF_INET, SOCK_STREAM, 0)) < 0 ) {
	printf("CCNET server: Error creating listening socket.\n");
	exit(EXIT_FAILURE);
    }
#ifdef NODELAY_OPTION
    if( setsockopt(list_s, SOL_TCP, TCP_NODELAY, &option, sizeof(option))
	< 0 ) {
      printf("CCNET server: Error setsocket(TCP_NODELAY)\n");
      exit(EXIT_FAILURE);
    }
#endif
#ifdef SO_REUSEADDR_OPTION
    if( setsockopt(list_s, SOL_SOCKET, SO_REUSEADDR, &option, sizeof(option))
	< 0 ) {
      printf("CCNET server: Error setsocket(SO_REUSEADDR)\n");
      exit(EXIT_FAILURE);
    }
#endif
    memset(&servaddr, 0, sizeof(servaddr));
    servaddr.sin_family      = AF_INET;
    servaddr.sin_addr.s_addr = htonl(INADDR_ANY);
    servaddr.sin_port        = htons(PORT);

    if ( bind(list_s, (struct sockaddr *) &servaddr, sizeof(servaddr)) < 0 ) {
	printf("CCNET server: Error calling bind()\n");
	exit(EXIT_FAILURE);
    }

    if ( listen(list_s, 5) < 0 ) {
	printf("CCNET server: Error calling listen()\n");
	exit(EXIT_FAILURE);
    }

    while ( 1 ) {

      if ( (conn_s = accept(list_s, NULL, NULL) ) < 0 ) {
          printf("CCNET server: Error calling accept()\n");
          exit(EXIT_FAILURE);
      }
      pid = fork();
      if (pid == 0){

      do {
	status = readMessage(conn_s, (char *)rcvbuf, HEADER_SIZE);
	if ( status ) {
	  printf("readMessage: error occurred...\n");
	  break; // exit from do while
	}else { // read a message successfully
	  for(i=0;i<HEADER_SIZE/4;i++)
	    rcvbuf[i] = ntohl(rcvbuf[i]);
#ifdef DEBUG
	  printf("ccnet_server:read : Header[0] = %d : Header[1] = %d\n", 
		 rcvbuf[0], rcvbuf[1]);
#endif
	  if( rcvbuf[0] > HEADER_SIZE) {
	    count = rcvbuf[0]-HEADER_SIZE;
	    status = readMessage(conn_s, (char *)&rcvbuf[2], count);
	    if ( status ) {
	      printf("readMessage: error occurred...\n");
	      break; // exit from do while
	    } else { // read a message successfully
	      for(i=0;i<count/4;i++)
		rcvbuf[i+2] = ntohl(rcvbuf[i+2]);
#ifdef DEBUG
	      printf("ccnet_server:read: cmdbuf[0] = %d : cmdbuf[1] = %d\n",
		     rcvbuf[2], rcvbuf[3]);
	      for(i=0; i< rcvbuf[3]; i++) {
		printf("read: cmdbuf[%d] = %x : cmdbuf[%d] = %x\n",
		       2*(i+2), rcvbuf[2*(i+2)], 2*(i+2)+1, rcvbuf[2*(i+2)+1]);
	      }
#endif
	    }
	  }
	}
	rcvlen = rcvbuf[0]; // total length received in bytes 
	sndbuf[3] = 0;      // initialize length of buffer to be sent
#ifdef DEBUG
	printf("ccnet_server: now dispatching...\n");
#endif
	status = dispatch( rcvbuf, rcvlen, sndbuf, &sndlen );
	if( status && (status != -5)) {
	  printf("dispatch: error occurred...\n");
	  break; // exit from do while
	}
#ifdef DEBUG
	printf("ccnet_server:write: Header[0] = %d : Header[1] = %d\n", 
	       sndbuf[0], sndbuf[1]);
	printf("ccnet_server:write: data[0] = %x : data[1] = %x\n", 
	       sndbuf[2], sndbuf[3]);
	printf("\n");
#endif
	for(i=0;i<sndlen/4;i++)
	  sndbuf[i]=htonl(sndbuf[i]);
	writeMessage(conn_s, (char *)sndbuf, sndlen );
      } while ((!status) && (status != -5));
      }else{
#ifdef DEBUG
      printf("close function is called...\n");
#endif
      if ( close(conn_s) < 0 ) {
	printf("CCNET server: Error calling close()\n");
	exit(EXIT_FAILURE);
      }

      }
    }
}
