#define TDC1 3
#define ADC1 1
#define ADC2 5
#define ADC3 20
#define OREG 22

#define LAM_N ADC1
#define LAM_A 0
#define LAM_F 26

int ccnet_int(int fd,int *buf,int *len){
    int lam_pattern,status;
    int i;
    
    for (i=0;i<8;i++){
      cam_gen_cc(buf,ADC1,i,0);
    }
    cam_gen_cc(buf,ADC3,0,0);
    cam_gen_cc(buf,ADC3,1,0);
    for (i=0;i<8;i++){
      cam_gen_cc(buf,TDC1,i,0);
    }
    *len = buf[1];
    return 0;
}

int ccnet_clr(int *buf,int *len){
    cam_gen_cc(buf,TDC1,0,9);
    cam_gen_cc(buf,ADC1,0,9);
    cam_gen_cc(buf,ADC3,0,9);
    *len = buf[1];
    return 0;
}

int ccnet_inton(int fd){
  int status;
  int data,q,x,lam_pattern,event_count;
  /*
  status = cam_enable_lam(fd,0xFFFFFF);
  status = cam_wait_lam(fd,&lam_pattern,TIMEOUT);
  data = 0x000f;
  status = cam_single_cc(fd,OREG,0,16,&data,&q,&x);*/

  status = cam_enable_trig(fd);
  status = cam_wait_trig(fd,&event_count,TIMEOUT);
  status = cam_disable_trig(fd);
  return 0;
}

int ccnet_intoff(int fd){
  int status,daq_status;
  int data,q,x,lam_pattern,event_count;
  status = cam_single_daq(fd,DAQEXE_CTRL_CLRBSY,&data,&daq_status);
  data = 0x0000;
  status = cam_single_cc(fd,OREG,0,16,&data,&q,&x);
  return 0;
}

int ccnet_start(int fd){
  int status,daq_status;
  int data,q,x,lam_pattern,event_count;
  data = 0x0000;
  status = cam_single_cc(fd,OREG,0,16,&data,&q,&x);
  status = cam_single_daq(fd,DAQEXE_CTRL_CLRCNT,&data,&daq_status);
  status = cam_single_daq(fd,DAQEXE_CTRL_CLRBSY,&data,&daq_status);
  status = cam_single_cc(fd,LAM_N,LAM_A,LAM_F,&data,&q,&x);
  return 0;
}

int ccnet_stop(int fd){
  int status,daq_status;
  int data,q,x,lam_pattern,event_count;
  data = 0xffff;
  status = cam_single_cc(fd,OREG,0,16,&data,&q,&x);
  status = cam_single_cc(fd,LAM_N,0,24,&data,&q,&x);
  return 0;
}

int module_clear(int fd){
  int data,q,x,status;
  status = cam_single_cc(fd,TDC1,0,9,&data,&q,&x);
  status = cam_single_cc(fd,ADC1,0,9,&data,&q,&x);
  status = cam_single_cc(fd,ADC3,0,9,&data,&q,&x);
  return 0;
}

int crate_clear(int fd){
    int data,q,x,status;
    status = cam_clear_fifo(fd);
    status = cam_single_cc(fd,25,0,17,&data,&q,&x);
    status = cam_single_cc(fd,25,0,16,&data,&q,&x);
    status = cam_single_cc(fd,25,0,24,&data,&q,&x);
#if (defined(LAM_N) &&defined(LAM_A))	
    status = cam_single_cc(fd,LAM_N,LAM_A,24,&data,&q,&x);
    status = cam_single_cc(fd,LAM_N,LAM_A,9,&data,&q,&x);
    status = cam_single_cc(fd,ADC1,0,24,&data,&q,&x);
    status = cam_single_cc(fd,ADC3,0,24,&data,&q,&x);
    status = cam_single_cc(fd,TDC1,0,24,&data,&q,&x);
#endif
  return 0;
}

int extract_data( int* rplybuf, int len, int* actuallen,
		  unsigned short  *data )
{
  int i,j, num;
  num = rplybuf[1]; // get number of reply frames
  if( num > len )
    return -2; // lots of data are included in rplybuf
  data[0] = num+1;
  for( i = 0; i < num; i++ )
    data[i+1] = rplybuf[2*i+2] & 0xFFFFFF;
/*  data[num+1] = DELIM; */
  *actuallen = num+1;
  return 0;
}
