/* ccnet_daq/bexecuter.c
 * last modified : 09/08/19 13:17:42 
 *
 * CC/NET Access program for babies
 * Original executer is made by T. Oonishi
 * 
 * Hidetada Baba (RIKEN)
 * baba@ribf.riken.jp
 *
 */


#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <signal.h>

#define COMFIFO "/tmp/babirldbfifo"

#include "command.h"
#include "pcc.h"

//#define TIMEOUT 60000
#define TIMEOUT 0
#define FRAME_LEN 300
#define BUF_LEN FRAME_LEN*2

static int     shmid;
static CRASHM *shmp;
static int     semid;
static struct  sembuf semops[1];
int j;
#include "ccnet_int.c"
#include "ridf.h"

/* Prototypes for library */
int initshm();

/* Defines for babies */
#define EB_EFBLOCK_SIZE 0x20000   // Usual max size of block data = 128kB
#define EB_EFBLOCK_BUFFSIZE EB_EFBLOCK_SIZE * 2  // Usual size of block data buffer
#define WORDSIZE      2
#define EF_SHM_SIZE   EB_EFBLOCK_BUFFSIZE * 2 + 12
#define EF_SHM_DATA1  0
#define EF_SHM_DATA2  EB_EFBLOCK_BUFFSIZE
#define EF_SHM_FLAG1  EB_EFBLOCK_BUFFSIZE * 2
#define EF_SHM_FLAG2  EB_EFBLOCK_BUFFSIZE * 2 + 2
#define EF_SHM_EVTN   EB_EFBLOCK_BUFFSIZE * 2 + 4
#define EF_SHM_SSF    EB_EFBLOCK_BUFFSIZE * 2 + 8
#define EF_SHM_RUN    EB_EFBLOCK_BUFFSIZE * 2 + 10
#define EF_SHM_FREE   0x00
#define EF_SHM_READY1 0x01
#define EF_SHM_READY2 0x02
#define EFSHMKEY    523400

int fd, cfd;
/* for babies */
int efn, bshmid, idx, size, mp;
char *buff, *buffat;
RIDFHD hd;
RIDFHDEVT evthd;
RIDFHDSEG seghd;

/* for event fragment */
unsigned short lbuff[EFSIZE*2];
unsigned int segid, evtn;
int hds, evthds, seghds;
int segs, evts;
volatile char ssflag, ssf;

/*    int data,q,x,lam_pattern; */
int len,len1,status,actual_length,length;
int commentlen, q, x; 
int cmdbuf[BUF_LEN+2],rplybuf[BUF_LEN+2];
int clrbuf[BUF_LEN+2];
unsigned short databuf[BUF_LEN+2];
unsigned short data;

#ifdef DEBUG
#define DB(x) x
#else
#define DB(x)
#endif

void quit(void){
#if  (defined(LAM_N) && defined(LAM_A))
  status = cam_disable_lam(fd);
  status = cam_single_cc(fd,LAM_N,LAM_A,24,&data,&q,&x);
#endif

  if(fd) close(fd);
  if(cfd) close(cfd);

  exit(0);
}


int datacopy(void){
  if(buff[EF_SHM_FLAG1] && buff[EF_SHM_FLAG2]){
    DB(printf("Both buffer full\n"));
    sleep(1);
    return 0;
  }else{
    if(idx == 0 && !buff[EF_SHM_FLAG1]){
      DB(printf("idx %d : memcpy\n", idx));
      buffat = buff + EF_SHM_DATA1;
      *(buff + EF_SHM_FLAG1) = EF_SHM_READY1;
    }else if(idx == 1 && !buff[EF_SHM_FLAG2]){
      DB(printf("idx %d : memcpy\n", idx));
      buffat = buff + EF_SHM_DATA2;
      *(buff + EF_SHM_FLAG2) = EF_SHM_READY2;
    }else{
      printf("Invalid shared memory management\n");
      printf("idx   = %d\n", idx);
      printf("flag1 = %d\n", buff[EF_SHM_FLAG1]);
      printf("flag2 = %d\n", buff[EF_SHM_FLAG2]);
      return 0;
    }
    
    hd = ridf_mkhd(RIDF_LY0, RIDF_EF_BLOCK, mp, efn);
    memcpy((char *)lbuff, (char *)&hd, hds*WORDSIZE);
    memcpy(buffat, (char *)lbuff, mp*WORDSIZE);

    mp = hds;
    
    flock(cfd, LOCK_EX);
    write(cfd, (char *)&idx, sizeof(idx));
    flock(cfd, LOCK_UN);
    if(idx == 0){
      idx = 1;
    }else{
      idx = 0;
    }
  }
  return 1;
}


int main(int argc, char *argv[]){
  fd = 0;
  cfd = 0;
  evtn = 0;
  segid = SEGID;
  ssflag = 0;
  ssf = 0;
  
  if(argc != 2){
    printf("bexecuter EFN\n");
    exit(0);
  }
  efn = strtol(argv[1], NULL, 0);
  if(efn < 1 || efn > 254){
    printf("0 < EFN < 255\n");
    exit(0);
  }
  if((cfd = open(COMFIFO, O_RDWR)) < 0){
    printf("Can't open COMFIFO\n");
    exit(1);
  }

  signal(SIGINT, (void *)quit);

  buff = 0;
  if((bshmid = initshm(EFSHMKEY+efn, EF_SHM_SIZE, &buff)) == -1){
    printf("initshm failed  shmid = %d\n", shmid);
    exit(0);
  }
  if(!buff){
    printf("Can't allocate shared memory %p\n", buff);
    exit(0);
  }
  DB(printf("shmid = %d / addr = %p\n", shmid, buff));
  memset(buff, 0, EF_SHM_SIZE);



  if ((shmid = shmget(SHMKEY, sizeof(CRASHM), IPC_CREAT|0600)) == -1)
    {puts("# Cannot create shared memory"); exit(2);}
  if ((semid = semget(SEMKEY, 1             , IPC_CREAT|0600)) == -1)
    {puts("# Cannot create semaphore"); exit(2);}
  shmp = (CRASHM *)shmat(shmid, 0, 0);
  
  if ((fd= cam_open()) == -1 ){
    printf("cam_open error\n");
    quit();
  }

  crate_clear(fd);
  length = 300;
  cam_gen_init(length,cmdbuf);
  cam_gen_init(length,rplybuf);
  cam_gen_init(length,clrbuf);
  ccnet_int(fd,cmdbuf,&len);
  ccnet_clr(clrbuf,&len1);

  ccnet_stop(fd);
  memset(lbuff, 0, sizeof(lbuff));

  evthds = sizeof(evthd)/WORDSIZE;
  seghds = sizeof(seghd)/WORDSIZE;
  hds = sizeof(hd)/WORDSIZE;

  mp = hds;
  idx = 0;
  
  for (;;){
    while(shmp->acquire == 1){
      if(ssflag == 0){
	DB(printf("DAQ start\n"));
        ccnet_start(fd);
	ssflag = 1;
	evtn = 0;
	ssf = 1;
	memcpy(buff + EF_SHM_SSF, (char *)&ssf, sizeof(ssf));
	printf("ssf %d\n", ssf);
      }
      status = 1;
      while(status != 0){
	status = ccnet_inton(fd);
	if (status > 0){
	  printf("status=%d\n",status);
          if (shmp->acquire == 0){
            goto stoproutine;
          }
	}
	cam_disable_trig(fd);
	cam_enable_trig(fd);
      }
      cam_disable_trig(fd);
      evtn++; DB(printf("evtn=%d\n", evtn));
      status = cam_exec(fd,cmdbuf,rplybuf);
      extract_data(rplybuf,len,&actual_length,databuf);
#if defined(DEBUG)	    
      //for (j = 0; j < actual_length; j++) 
     // 	printf("data %d %x\n",j,databuf[j]);
     // fflush(stdout);
#endif
      status = cam_exec(fd,clrbuf,rplybuf);

      /* RIDF */
      evts = actual_length + evthds + seghds - 1;
      evthd = ridf_mkhd_evt(RIDF_LY1, RIDF_EVENT, evts, efn, evtn);
      memcpy((char *)(lbuff+mp), (char *)&evthd, evthds*WORDSIZE);
      mp += evthds;
      segs = actual_length + seghds - 1;
      seghd = ridf_mkhd_seg(RIDF_LY2, RIDF_SEGMENT, segs, efn, segid);
      memcpy((char *)(lbuff+mp), (char *)&seghd, seghds*WORDSIZE);
      mp += seghds;
      memcpy((char *)(lbuff+mp), (char *)(databuf+1),
	     (actual_length-1)*sizeof(short));
      mp += actual_length - 1;

      if(mp > EFSIZE){
	while(!datacopy());
      }

      ccnet_intoff(fd);
    }
stoproutine:

    if(shmp->acquire == 0){
      if(ssflag == 1){
	ccnet_stop(fd);
	ssflag = 0;
        DB(printf("DAQ stop\n"));
	if(mp > hds){
	  while(!datacopy());
	}

	memcpy(buff + EF_SHM_EVTN, (char *)&evtn, sizeof(evtn));
	printf("evtn %d\n", evtn);
	ssf = 0;
	memcpy(buff + EF_SHM_SSF, (char *)&ssf, sizeof(ssf));
	printf("ssf %d\n", ssf);

	usleep(10000);
	idx = -1;
	DB(printf("bexecuter: put end-flag to fifo\n"));
	flock(cfd, LOCK_EX);
	write(cfd, (char *)&idx, sizeof(idx));
	flock(cfd, LOCK_UN);
	idx = 0;
      }else{
	usleep(10000);
      }
    }
  }
}
