#include <sys/socket.h>
#include <sys/types.h>
#include <arpa/inet.h>
#include <netinet/tcp.h>

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <signal.h>

#include "command.h"

extern void hstdef_();
extern void event1_(unsigned short *);
extern void hstend_();

int main(int argc, char *argv[]){
  int list_s;
  int conn_s;
  short int port;
  struct sockaddr_in servaddr;
  unsigned short int sndbuf[MAX_BUF];
  unsigned short int rcvbuf[MAX_BUF];
  int sndlen,rcvlen;
  int status,i,buff,ievt;
  unsigned int evtlen;
  int opt;
  /* Network initialize */  
  
  if ( (list_s = socket(AF_INET, SOCK_STREAM, 0)) < 0 ) {
    printf("Analysis server: Error creating listening socket.\n");
    exit(EXIT_FAILURE);
  }
  
  memset(&servaddr, 0, sizeof(servaddr));
  servaddr.sin_family      = AF_INET;
  servaddr.sin_addr.s_addr = htonl(INADDR_ANY);
  servaddr.sin_port        = htons(ANA_PORT);

  if ( bind(list_s, (struct sockaddr *) &servaddr, sizeof(servaddr)) < 0 ) {
    printf("Analysis server: Error calling bind()\n");
    exit(EXIT_FAILURE);
  }
  if ( listen(list_s, 5) < 0 ) {
    printf("Analysis server: Error calling listen()\n");
    exit(EXIT_FAILURE);
  }

  hstdef_();
  while(1){
    if ( (conn_s = accept(list_s, NULL, NULL) ) < 0 ) {
      printf("Analysis server: Error calling accept()\n");
      exit(EXIT_FAILURE);
    }
    do {
      ievt = 0;
      status = readMessage(conn_s,&buff,sizeof(short));
      rcvlen = buff*sizeof(short);
      readMessage(conn_s,(char *)rcvbuf,rcvlen);
      while (buff > 0){
	/* printf("<< RECIEVED >>"); */
	evtlen = rcvbuf[ievt];
	event1_(&rcvbuf[ievt]);
	/*for (i = 0;i<evtlen;i++){
	  printf("recieved:%x\n",rcvbuf[ievt+i]);
	  }
	  printf("1 evt end\n");*/
	ievt += evtlen;
	buff -= evtlen;
      }
    }while((!status)&&(status != -5));
    if ( close(conn_s) < 0 ) {
      printf("Analysis server: Error calling close()\n");
      exit(EXIT_FAILURE);
    }
  }
  hstend_();
}

