#include <stdio.h>
#include <sys/types.h>
#include <netdb.h>

#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <signal.h>

#include "command.h"

static int     shmid;
static CRASHM *shmp;
static int     semid;
static struct  sembuf semops[1];

static  int       conn_s;                /*  connection socket         */
static  struct    sockaddr_in servaddr;  /*  socket address structure  */
static  struct    hostent *host;
static  unsigned short int sndbuf[MAX_BUF];
static  unsigned short int rcvbuf[MAX_BUF];
static  int buff;

int close_net(){
  close(conn_s);
  exit(0);
}

int open_net(){
    conn_s = socket( AF_INET, SOCK_STREAM, 0 );
    servaddr.sin_port        = htons(ANA_PORT);
    host = (struct hostent *)gethostbyname( (const char *)ANA_HOST);
    if( !host )
      {
        printf( "Analysis client: Error resolving hostname" );
        exit( 1 );
      }
    bcopy( (char *)host->h_addr, (char *)&servaddr.sin_addr, host->h_length );
    servaddr.sin_family      = host->h_addrtype;
    if ( connect(conn_s, (struct sockaddr *)&servaddr, sizeof(servaddr) ) < 0){
      printf("Analsys client: Error calling connect()\n");
/*      exit(1); */
    }
    return 0;
}

int main(int argc,char *argv[]){
  
  int i,evtlen,buff,sndlen,ievt;
  if ((shmid = shmget(SHMKEY, sizeof(CRASHM), IPC_CREAT|0600)) == -1)
    {puts("# Cannot create shared memory"); exit(2);}
  if ((semid = semget(SEMKEY, 1             , IPC_CREAT|0600)) == -1)
    {puts("# Cannot create semaphore"); exit(2);}
  shmp = (CRASHM *)shmat(shmid, 0, 0);
  signal(SIGINT,(void *)close_net);
  open_net();  
  ievt = 0;
  for (;;){
    while (shmp->rp >= shmp->wp) {
      semops[0].sem_num =  0;
      semops[0].sem_op  = -1;
      semops[0].sem_flg =  0;
      semop(semid, semops, 1);
    }
    evtlen = shmp->buff[shmp->rp%MAX_BUF];
    if ((ievt+evtlen) > MAX_BUF){
      buff = ievt;
      sndlen = buff*sizeof(short);
      writeMessage(conn_s,&buff,sizeof(short));
      writeMessage(conn_s,(char *)sndbuf,sndlen);
      ievt = 0;
      /*      printf("<< SEND >>\n"); */
      fflush(stdout);
    }
    for (i = 0;i<evtlen;i++){
      sndbuf[ievt+i] = shmp->buff[(shmp->rp + i)%MAX_BUF];
    }
    shmp->rp +=evtlen;
    ievt += evtlen;
  }
}



