#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>
#include <stdlib.h>
#include <stdio.h>
#include <signal.h>

#include "command.h"

extern void hstdef_();
extern void event1_(unsigned short *);
extern void hstend_();

static int     shmid;
static CRASHM *shmp;
static int     semid;
static struct
       sembuf  semops[1];

int main()
{
  unsigned int evtlen;
  if ((shmid = shmget(SHMKEY, sizeof(CRASHM), IPC_CREAT|0600)) == -1)
    {puts("# Cannot create shared memory"); exit(2);}
  if ((semid = semget(SEMKEY, 1             , IPC_CREAT|0600)) == -1)
    {puts("# Cannot create semaphore"); exit(2);}
  shmp = (CRASHM *)shmat(shmid, 0, 0);
  signal(SIGINT, hstend_); /* routine called at end of analyzer */
  hstdef_(); fflush(stdout); /* histogram definition */
  for (;;) {
    while (shmp->rp >= shmp->wp) { /* data is not ready, wait ... */
      semops[0].sem_num =  0;
      semops[0].sem_op  = -1;
      semops[0].sem_flg =  0;
      semop(semid, semops, 1);
    }
    evtlen = shmp->buff[shmp->rp%MAX_BUF];
    if (shmp->buff[(shmp->rp + evtlen-1)%MAX_BUF] == DELIM) { /* good event */
      event1_(&(shmp->buff[shmp->rp%MAX_BUF]));    /* call 1-event analyzer */
      fflush(stdout);
      shmp->ancnt++;                        /* increment "analyzed" counter */
      shmp->rp += evtlen;                      /* set pointer to next event */
    } else {
      shmp->ercnt++;                           /* increment "error" counter */
      while (shmp->buff[(shmp->rp++)%MAX_BUF] != DELIM)
	if (shmp->rp >= shmp->wp) break;               /* search next event */
    }
  }
}
