/*
   V830 VME Scaler/Counter
*/

#define V830_NCH                         32
#define V830_MODE1                       0x0004

/* Address Map */
#define V830_CONTROL_REGISTER            0x000
#define V830_STATUS_REGISTER             0x000
#define V830_IRQ_CONTROL                 0x004
#define V830_SLECTIVE_COUNT_DISABLE      0x00c
#define V830_CLEAR_ALL_COUNTERS          0x020
#define V830_CLOCK_SHADOW_REGISTER       0x024
#define V830_GLOBAL_COUNT_ENABLE         0x028
#define V830_GLOBAL_COUNT_DISABLE        0x02c
#define V830_BC_CLEAR_ALL_COUNTERS       0x030
#define V830_BC_CLOCK_SHADOW_REGISTER    0x034
#define V830_BC_GLOBAL_COUNT_ENABLE      0x038
#define V830_BC_GLOBAL_COUNT_DISABLE     0x03c
#define V830_CLEAR_COUNTER_GROUP         0x040 /* - 0x04c */
#define V830_ENABLE_REFERENCE_PULSER     0x050
#define V830_DISABLE_REFERENCE_PULSER    0x054
#define V830_RESET_REGISTER_GLOBAL       0x060
#define V830_TEST_PULSE                  0x068
#define V830_CLEAR_COUNTER               0x100 /* - 0x17c */
#define V830_CLEAR_OVERFLOW              0x180 /* - 0x1fc */
#define V830_READ_SHADOW_REGISTER        0x200 /* - 0x27c */
#define V830_READ_COUNTER                0x280 /* - 0x2fc */
#define V830_READ_AND_CLEAR_ALL_COUNTERS 0x300 /* - 0x37c */
#define V830_OVERFLOW_REGISTER_01_08     0x380
#define V830_OVERFLOW_REGISTER_09_16     0x3A0
#define V830_OVERFLOW_REGISTER_17_24     0x3C0
#define V830_OVERFLOW_REGISTER_25_32     0x3E0


/* Bits for Read Status Register */
#define V830_STATUS_IRQ_SOURCE_2        0x40000000
#define V830_STATUS_IRQ_SOURCE_1        0x20000000
#define V830_STATUS_IRQ_SOURCE_0        0x10000000
#define V830_VME_IRQ                    0x08000000
#define V830_INTERNAL_VME_IRQ           0x04000000
#define V830_STATUS_IRQ_ENABLE_S2       0x00400000
#define V830_STATUS_IRQ_ENABLE_S1       0x00200000
#define V830_STATUS_IRQ_ENABLE_S0       0x00100000
#define V830_RESERVED                   0x00010000
#define V830_GLOBAL_COUNTER_ENABLE      0x00008000
#define V830_GENERAL_OVERFLOW           0x00004000
#define V830_STATUS_ENABLE_REF_PULSER1  0x00002000
#define V830_STATUS_BROADCAST_HANDSHAKE 0x00000080
#define V830_STATUS_BROADCAST           0x00000040
#define V830_STATUS_INPUT_TEST          0x00000020
#define V830_STATUS_25MHZ_TEST_PULSES   0x00000010
#define V830_STATUS_INPUT_BIT1          0x00000008
#define V830_STATUS_INPUT_BIT0          0x00000004
#define V830_STATUS_IRQ_S2_SOFTWARE_IRQ 0x00000002
#define V830_STATUS_USER_LED            0x00000001

/* Bits for Write Control Register */
#define V830_DISABLE_IRQ_SOURCE_2        0x40000000
#define V830_DISABLE_IRQ_SOURCE_1        0x20000000
#define V830_DISABLE_IRQ_SOURCE_0        0x10000000
#define V830_CLEAR_RESERVED_BIT          0x01000000
#define V830_ENABLE_IRQ_ENABLE_S2        0x00400000
#define V830_ENABLE_IRQ_ENABLE_S1        0x00200000
#define V830_ENABLE_IRQ_ENABLE_S0        0x00100000
#define V830_SET_RESERVED_BIT            0x00010000
#define V830_DISABLE_BROADCAST_HANDSHAKE 0x00008000
#define V830_DISABLE_BROADCAST           0x00004000
#define V830_DISABLE_INPUT_TEST          0x00002000
#define V830_DISABLE_25MHZ_TEST_PULSES   0x00001000
#define V830_CLEAR_INPUT_BIT1            0x00000800
#define V830_CLEAR_INPUT_BIT0            0x00000400
#define V830_CLEAR_IRQ_S2_SOFTWARE_IRQ   0x00000200
#define V830_CLEAR_USER_LED              0x00000100
#define V830_ENABLE_BROADCAST_HANDSHAKE  0x00000080
#define V830_ENABLE_BROADCAST            0x00000040
#define V830_ENABLE_INPUT_TEST           0x00000020
#define V830_ENABLE_25MHZ_TEST_PULSES    0x00000010
#define V830_SET_INPUT_BIT1              0x00000008
#define V830_SET_INPUT_BIT0              0x00000004
#define V830_SET_IRQ_S2_SOFTWARE_IRQ     0x00000002
#define V830_SET_USER_LED                0x00000001

