/* madc32 */

#include "madc32.h"

void madc32_clear_map(int n){
  short val;

  val = 1;
  univ_map_write16(MADC32_READOUT_RESET, &val, n);

}

void madc32_start_acq_map(int n){
  short val;

  val = 1;
  univ_map_write16(MADC32_START_ACQ, &val, n);
}

void madc32_stop_acq_map(int n){
  short val;

  val = 0;
  univ_map_write16(MADC32_START_ACQ, &val, n);
}

void madc32_irq_level(int n, short val){

  univ_map_write16(MADC32_IRQ_LEVEL, &val, n);
}

void madc32_resol_8khires(int n){
  short val;

  val = 4;
  univ_map_write16(MADC32_ADC_RESOLUTION, &val, n);
}

void madc32_input_range(int n, short val){
  univ_map_write16(MADC32_INPUT_RANGE, &val, n);
}


void madc32_module_id(int n, short val){
  univ_map_write16(MADC32_MODULE_ID, &val, n);
}

int madc32_segdata_map(int n){
  volatile short cnt, i;

  univ_map_read16(MADC32_BUFFER_DATA_LENGTH, (short *)&cnt, n);
  cnt = cnt & 0x3fff;

  for(i=0;i<cnt;i++){
    univ_map_read32(MADC32_DATA, (long *)(data+mp), n);
    mp += 2;
    segmentsize += 2;
  }

  return segmentsize;
}


