#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <bi-config.h>
#include <bi-common.h>
#include <bbxml.h>

#include "babildxcom.h"

extern struct stdaqinfo daqinfo;
extern struct struninfo runinfo;
extern struct stssminfo ssminfo;
extern void store_daqinfo();
extern void store_runinfo();
extern void store_eflist();
extern void store_hdlist();
extern void store_ssminfo();
extern int addaliasname(char *aliasname);
extern int fchkerhost;
extern char aliasnames[10][128];

int babildxcom(char *buff, char *ret){
  BBXMLEL *dom, *top, *tnode, *rdom, *rtop;
  int sz=0, i;

  rdom = bbxml_DomDocument();
  dom = bbxml_parsebuff(buff, strlen(buff));
  rtop = bbxml_appendChild(rdom, bbxml_createElement("babild", ""));
			   
  if((top = bbxml_node(dom, "babildxcom"))){
    i = 0;
    while(xcom[i].name){
      tnode = bbxml_node(top, xcom[i].name);
      if(tnode){
	(*xcom[i].func)(tnode, rtop);
      }
      i++;
    }
  }else{
    bbxml_appendChild(rtop, bbxml_createElement("error", "This is babild(XML), but commond is not babildxcom"));
  }
  
  bbxml_free(dom);
  sz = bbxml_sprintall(rdom, ret);
  bbxml_free(rdom);

  return sz;
}


/* babild functions */
int xgeteflist(BBXMLEL *nd, BBXMLEL *ret){
  char tstr[BBXML_TEXTMAX];
  int i;
  BBXMLEL *dinfo, *eflist;

  if(strcmp(ret->tag, "daqinfo")){
    dinfo = bbxml_appendChild(ret, bbxml_createElement("daqinfo", ""));
  }else{
    dinfo = ret;
  }

  for(i=0;i<MAXEF;i++){
    if(daqinfo.eflist[i].ex){
      eflist = bbxml_appendChild(dinfo, bbxml_createElement("eflist", ""));
      sprintf(tstr, "%d", i);
      bbxml_appendChild(eflist, bbxml_createElement("efn", tstr));
      sprintf(tstr, "%d", daqinfo.eflist[i].ex);
      bbxml_appendChild(eflist, bbxml_createElement("ex", tstr));
      sprintf(tstr, "%d", daqinfo.eflist[i].of);
      bbxml_appendChild(eflist, bbxml_createElement("of", tstr));
      bbxml_appendChild(eflist, bbxml_createElement("name", daqinfo.eflist[i].name));
      bbxml_appendChild(eflist, bbxml_createElement("host", daqinfo.eflist[i].host));
    }
  }

  return 1;
}

int xgethdlist(BBXMLEL *nd, BBXMLEL *ret){
  char tstr[BBXML_TEXTMAX];
  int i;
  BBXMLEL *dinfo, *hdlist;

  if(strcmp(ret->tag, "daqinfo")){
    dinfo = bbxml_appendChild(ret, bbxml_createElement("daqinfo", ""));
  }else{
    dinfo = ret;
  }

  for(i=0;i<MAXHD;i++){
    if(daqinfo.hdlist[i].ex){
      hdlist = bbxml_appendChild(dinfo, bbxml_createElement("hdlist", ""));
      sprintf(tstr, "%d", i);
      bbxml_appendChild(hdlist, bbxml_createElement("hdn", tstr));
      sprintf(tstr, "%d", daqinfo.hdlist[i].ex);
      bbxml_appendChild(hdlist, bbxml_createElement("ex", tstr));
      sprintf(tstr, "%d", daqinfo.hdlist[i].of);
      bbxml_appendChild(hdlist, bbxml_createElement("of", tstr));
      bbxml_appendChild(hdlist, bbxml_createElement("path", daqinfo.hdlist[i].path));
      sprintf(tstr, "%llu", daqinfo.hdlist[i].free);
      bbxml_appendChild(hdlist, bbxml_createElement("free", tstr));
      sprintf(tstr, "%llu", daqinfo.hdlist[i].full);
      bbxml_appendChild(hdlist, bbxml_createElement("full", tstr));
      sprintf(tstr, "%llu", daqinfo.hdlist[i].maxsize);
      bbxml_appendChild(hdlist, bbxml_createElement("maxsize", tstr));
    }
  }

  return 1;
}

int xgetdaqinfo(BBXMLEL *nd, BBXMLEL *ret){
  char tstr[BBXML_TEXTMAX];
  BBXMLEL *dinfo;

  dinfo = bbxml_appendChild(ret, bbxml_createElement("daqinfo", ""));
  bbxml_appendChild(dinfo, bbxml_createElement("runname", daqinfo.runname));
  sprintf(tstr, "%d", daqinfo.runnumber);
  bbxml_appendChild(dinfo, bbxml_createElement("runnumber", tstr));
  sprintf(tstr, "%d", daqinfo.ebsize);
  bbxml_appendChild(dinfo, bbxml_createElement("ebsize", tstr));
  sprintf(tstr, "%d", daqinfo.efn);
  bbxml_appendChild(dinfo, bbxml_createElement("efn", tstr));
  sprintf(tstr, "%d", daqinfo.babildes);
  bbxml_appendChild(dinfo, bbxml_createElement("babildes", tstr));

  xgeteflist(NULL, dinfo);
  xgethdlist(NULL, dinfo);


  return 1;
}

int xseteflist(BBXMLEL *nd, BBXMLEL *ret){
  BBXMLEL *eflist, *efn, *host, *name, *of, *ex;
  int nefn = 0;

  if(runinfo.runstat){
    bbxml_appendChild(ret, bbxml_createElement("error", "seteflist: Now running!"));
    return 0;
  }

  DB(printf("babldxcom xseteflist"));
  eflist = bbxml_node(nd, "eflist");
  while(eflist){
    efn = bbxml_node(eflist, "efn");
    host = bbxml_node(eflist, "host");
    name = bbxml_node(eflist, "name");
    of = bbxml_node(eflist, "of");
    ex = bbxml_node(eflist, "ex");

    if(efn){
      nefn = strtol(efn->text, NULL, 0);
      if(nefn > 0 && nefn < 256){
	if(host) strcpy(daqinfo.eflist[nefn].host, host->text);
	if(name) strcpy(daqinfo.eflist[nefn].name, name->text);
	if(of)  daqinfo.eflist[nefn].of = strtol(of->text, NULL, 0);
	if(ex)  daqinfo.eflist[nefn].ex = strtol(ex->text, NULL, 0);
      }
    }
    eflist = bbxml_next(eflist, "eflist");
  }
  store_eflist();
  store_daqinfo();

  return 1;
}

int xsethdlist(BBXMLEL *nd, BBXMLEL *ret){
  BBXMLEL *hdlist, *hdn, *path, *of, *ex;
  int nhdn = 0;

  if(runinfo.runstat){
    bbxml_appendChild(ret, bbxml_createElement("error", "sethdlist: Now running!"));
    return 0;
  }

  hdlist = bbxml_node(nd, "hdlist");
  while(hdlist){
    hdn = bbxml_node(hdlist, "hdn");
    path = bbxml_node(hdlist, "path");
    of = bbxml_node(hdlist, "of");
    ex = bbxml_node(hdlist, "ex");

    if(hdn){
      nhdn = strtol(hdn->text, NULL, 0);
      if(nhdn >= 0 && nhdn < MAXHD){
	if(path) strcpy(daqinfo.hdlist[nhdn].path, path->text);
	if(of)  daqinfo.hdlist[nhdn].of = strtol(of->text, NULL, 0);
	if(ex)  daqinfo.hdlist[nhdn].ex = strtol(ex->text, NULL, 0);
      }
    }
    hdlist = bbxml_next(hdlist, "hdlist");
  }
  store_hdlist();

  return 1;
}

int xsetruninfo(BBXMLEL *nd, BBXMLEL *ret){
  BBXMLEL *runname, *runnumber;
  int n = 0;

  DB(printf("xsetruninfo\n"));

  if(runinfo.runstat){
    bbxml_appendChild(ret, bbxml_createElement("error", "setrunname: Now running!"));
    return 0;
  }

  runname = bbxml_node(nd, "runname");
  runnumber = bbxml_node(nd, "runnumber");

  if(runname){
    strcpy(daqinfo.runname, runname->text);
  }

  if(runnumber){
    n = strtol(runnumber->text, NULL, 0);
    if(n >= 0){
      daqinfo.runnumber = n;
      runinfo.runnumber = n;
    }
  }
  store_daqinfo();

  return 1;
}


int xsetaliasname(BBXMLEL *nd, BBXMLEL *ret){
  DB(printf("xsetaliasname\n"));

  if(runinfo.runstat){
    bbxml_appendChild(ret, bbxml_createElement("error", "aliasname: Now running!"));
    return 0;
  }

  if(nd->text){
    addaliasname(nd->text);
  }

  return 1;
}

/* babild initial function */
int xgetinitialize(char *ret){
  char tstr[BBXML_TEXTMAX];
  BBXMLEL *rdom, *initel;
  int i;

  rdom = bbxml_DomDocument();
  initel = bbxml_appendChild(rdom, bbxml_createElement("babildxcom", ""));

  /* chkerhost */
  sprintf(tstr, "%d", fchkerhost);
  bbxml_appendChild(initel, bbxml_createElement("setchkerhost", tstr));
  for(i=0;i<10;i++){
    if(strlen(aliasnames[i])){
      bbxml_appendChild(initel, bbxml_createElement("setaliasname", aliasnames[i]));    }
  }

  bbxml_sprintall(rdom, ret);

  return 1;
}

int xsetchkerhost(BBXMLEL *nd, BBXMLEL *ret){
  DB(printf("xseterhost %s\n", nd->text));

  if(runinfo.runstat){
    bbxml_appendChild(ret, bbxml_createElement("error", "setchkerhost: Now running!"));
    return 0;
  }

  fchkerhost = (int)strtol(nd->text, NULL, 0);
  store_daqinfo();

  return 1;
}
