/* viewana.c
   View Anapaw Parameters

   Sep 9, 2000  H.Baba
*/


#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <pthread.h>
#include <unistd.h>
#include <signal.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Xaw3d/Command.h>
#include <X11/Xaw3d/Paned.h>
#include <X11/Xaw3d/Label.h>
#include <X11/Xaw3d/AsciiText.h>
#include <X11/Xaw3d/Form.h>

#define font_list "-*-*-medium-r-*--12-*-*-*-*-*-*-*"


void setText(int m);
void showFrame(void);
void makeWidget(void);
void update_param(void);

XFontSet xfontset;
XEvent xevt;
XtAppContext app_context;
Widget toplevel;
Widget panel,label,text,
  quitButton,gateButton,andButton,orButton,xyButton,
       odButton,tdButton;
Arg xarg[20];
int i,j,realizeflag,currentm = 0;
char param[6][200][134];
char viewpid[80];
FILE *fd;
 
void quit_proc(void){
  XtUnrealizeWidget(toplevel);
  realizeflag = 0;
  execl("/bin/rm","rm",viewpid,NULL);
  exit(0);
}

void showFrame(void){
  realizeflag = 1;
  XtRealizeWidget(toplevel);
  XtAppMainLoop(app_context);
}

void gate_proc(void){
  setText(0);
}

void and_proc(void){
  setText(1);
}

void or_proc(void){
  setText(2);
}

void xy_proc(void){
  setText(3);
}

void od_proc(void){
  setText(4);
}

void td_proc(void){
  setText(5);
}

void setText(int m){
  XawTextBlock textbuf;
  static XawTextPosition pos = 0;

  update_param();
  currentm = m;

  i=0;
  XtSetArg(xarg[i],XtNeditType,XawtextEdit); i++;
  XtSetArg(xarg[i],XtNstring,NULL); i++;
  XtSetValues(text,xarg,i);

  i=0;
  while(strlen(param[m][i]) > 0){
    textbuf.ptr = param[m][i];
    textbuf.length = strlen(textbuf.ptr);
    textbuf.firstPos = 0;
    textbuf.format = FMT8BIT;
    XawTextReplace(text,pos,pos,&textbuf);
    pos = pos + textbuf.length;
    i++;
  }

  i=0;
  XtSetArg(xarg[i],XtNeditType,XawtextRead); i++;
  XtSetValues(text,xarg,i);
}


void update_param(void){
  char line[134];
  char vparam[80];
  int atflag = -1,atnum;
  char lspc[134];

  for(i=0;i<134;i++){
    lspc[i]=0;
  }

  strcpy(vparam,getenv("VIEWANA_PARAM"));

  if((fd = fopen(vparam,"r")) == NULL){
    perror("Can't open a parameter file.");
    exit(1);
  }

  while(fgets(line,134,fd) != NULL){
    if(strcmp(line,"@gate\n") == 0){
      atflag = 0;
      atnum = 0;
    }else if(strcmp(line,"@and\n") == 0){
      atflag = 1;
      atnum = 0;
    }else if(strcmp(line,"@or\n") == 0){
      atflag = 2;
      atnum = 0;
    }else if(strcmp(line,"@xy\n") == 0){
      atflag = 3;
      atnum = 0;
    }else if(strcmp(line,"@1D\n") == 0){
      atflag = 4;
      atnum = 0;
    }else if(strcmp(line,"@2D\n") == 0){
      atflag = 5;
      atnum = 0;
    }else if(atflag != -1){
      memcpy(param[atflag][atnum],lspc,134);
      memcpy(param[atflag][atnum],line,strlen(line));
      atnum++;
    }
  }

  fclose(fd);

  //setText(currentm);
}

void setPID(void){
  int pid;

  strcpy(viewpid,getenv("VIEWANA_PID"));

  fd = fopen(viewpid,"w");
  pid = getpid();
  fprintf(fd,"%d\n",pid);
  fclose(fd);
}


/* main loop */
int main(int argc,char *argv[]){
  signal(50,(void *)&update_param);

  makeWidget();

  setPID();

  showFrame();
}


/* Widget */
void makeWidget(void){
  int argc = 1;
  char *argv[1];
  Display *display;
  char **miss_list;
  char *def;
  int miss_count;


  argv[0] = "Viewana (H.Baba)";

  toplevel = XtVaAppInitialize(
         &app_context,           /* Application context */
	 "frame",                /* Application class */
	 NULL, 0,                /* command line */
	 &argc,argv,            /* command line args */
	 NULL,                   /* for missing app-defaults file */
	 NULL
	 );

  panel = XtVaCreateManagedWidget(
         "panel",                /* arbitrary widget name */
	 formWidgetClass,        /* widget class from Form.h */
	 toplevel,               /* parent widget */
	 XtVaTypedArg,XtNbackground,XtRString,"LightSteelBlue",strlen("LightSteelBlue")+1,
	 NULL);                  /* tarminate varargs list */


  quitButton = XtVaCreateManagedWidget(
         "quit",commandWidgetClass,panel,
	 XtNlabel,"Quit",
	 XtNhorizDistance,270,
	 XtNvertDistance,10,
	 XtNwidth,35,
	 XtNheight,20,
	 XtNtop,XawChainTop,
	 XtNbottom,XawChainTop,
	 XtNleft,XawChainLeft,
	 XtNright,XawChainLeft,
	 XtVaTypedArg,XtNforeground,XtRString,"NavyBlue",strlen("NavyBlue")+1,
	 XtVaTypedArg,XtNbackground,XtRString,"PaleGoldenrod",strlen("PaleGoldenrod")+1,
	 NULL);
  gateButton = XtVaCreateManagedWidget(
         "gate",commandWidgetClass,panel,
	 XtNlabel,"Gate",
	 XtNhorizDistance,10,
	 XtNvertDistance,10,
	 XtNwidth,35,
	 XtNheight,20,
	 XtNtop,XawChainTop,
	 XtNbottom,XawChainTop,
	 XtNleft,XawChainLeft,
	 XtNright,XawChainLeft,
	 XtVaTypedArg,XtNforeground,XtRString,"NavyBlue",strlen("NavyBlue")+1,
	 XtVaTypedArg,XtNbackground,XtRString,"PaleGoldenrod",strlen("PaleGoldenrod")+1,
	 NULL);

  andButton = XtVaCreateManagedWidget(
	 "and",commandWidgetClass,panel,
	 XtNlabel,"And",
	 XtNhorizDistance,50,
	 XtNvertDistance,10,
	 XtNwidth,35,
	 XtNheight,20,
	 XtNtop,XawChainTop,
	 XtNbottom,XawChainTop,
	 XtNleft,XawChainLeft,
	 XtNright,XawChainLeft,
	 XtVaTypedArg,XtNforeground,XtRString,"NavyBlue",strlen("NavyBlue")+1,
	 XtVaTypedArg,XtNbackground,XtRString,"PaleGoldenrod",strlen("PaleGoldenrod")+1,
	 NULL);

  orButton = XtVaCreateManagedWidget(
	 "or",commandWidgetClass,panel,
	 XtNlabel,"Or",
	 XtNhorizDistance,90,
	 XtNvertDistance,10,
	 XtNwidth,35,
	 XtNheight,20,
	 XtNtop,XawChainTop,
	 XtNbottom,XawChainTop,
	 XtNleft,XawChainLeft,
	 XtNright,XawChainLeft,
	 XtVaTypedArg,XtNforeground,XtRString,"NavyBlue",strlen("NavyBlue")+1,
	 XtVaTypedArg,XtNbackground,XtRString,"PaleGoldenrod",strlen("PaleGoldenrod")+1,
	 NULL);

  xyButton = XtVaCreateManagedWidget(
	 "xy",commandWidgetClass,panel,
	 XtNlabel,"X-Y",
	 XtNhorizDistance,130,
	 XtNvertDistance,10,
	 XtNwidth,35,
	 XtNheight,20,
	 XtNtop,XawChainTop,
	 XtNbottom,XawChainTop,
	 XtNleft,XawChainLeft,
	 XtNright,XawChainLeft,
	 XtVaTypedArg,XtNforeground,XtRString,"NavyBlue",strlen("NavyBlue")+1,
	 XtVaTypedArg,XtNbackground,XtRString,"PaleGoldenrod",strlen("PaleGoldenrod")+1,
	 NULL);

  odButton = XtVaCreateManagedWidget(
	 "1d",commandWidgetClass,panel,
	 XtNlabel,"1D",
	 XtNhorizDistance,170,
	 XtNvertDistance,10,
	 XtNwidth,35,
	 XtNheight,20,
	 XtNtop,XawChainTop,
	 XtNbottom,XawChainTop,
	 XtNleft,XawChainLeft,
	 XtNright,XawChainLeft,
	 XtVaTypedArg,XtNforeground,XtRString,"NavyBlue",strlen("NavyBlue")+1,
	 XtVaTypedArg,XtNbackground,XtRString,"PaleGoldenrod",strlen("PaleGoldenrod")+1,
	 NULL);

  tdButton = XtVaCreateManagedWidget(
	 "2d",commandWidgetClass,panel,
	 XtNlabel,"2D",
	 XtNhorizDistance,210,
	 XtNvertDistance,10,
	 XtNwidth,35,
	 XtNheight,20,
	 XtNtop,XawChainTop,
	 XtNbottom,XawChainTop,
	 XtNleft,XawChainLeft,
	 XtNright,XawChainLeft,
	 XtVaTypedArg,XtNforeground,XtRString,"NavyBlue",strlen("NavyBlue")+1,
	 XtVaTypedArg,XtNbackground,XtRString,"PaleGoldenrod",strlen("PaleGoldenrod")+1,
	 NULL);

  text = XtVaCreateManagedWidget(
         "textarea",asciiTextWidgetClass,panel,
	 XtNhorizDistance,10,
	 XtNvertDistance,40,
	 XtNscrollVertical,XawtextScrollWhenNeeded,
	 XtNscrollHorizontal,XawtextScrollWhenNeeded,
	 XtNeditType,XawtextEdit,
	 XtNwidth,400,
	 XtNheight,300,
	 XtNtop,XawChainTop,
	 XtNbottom,XawChainTop,
	 XtNleft,XawChainLeft,
	 XtNright,XawChainLeft,
	 XtVaTypedArg,XtNbackground,XtRString,"Beige",strlen("Beige")+1,
	 NULL);

  XtAddCallback(quitButton,XtNcallback,(void *)quit_proc,NULL);
  XtAddCallback(gateButton,XtNcallback,(void *)gate_proc,NULL);
  XtAddCallback(andButton,XtNcallback,(void *)and_proc,NULL);
  XtAddCallback(orButton,XtNcallback,(void *)or_proc,NULL);
  XtAddCallback(xyButton,XtNcallback,(void *)xy_proc,NULL);
  XtAddCallback(odButton,XtNcallback,(void *)od_proc,NULL);
  XtAddCallback(tdButton,XtNcallback,(void *)td_proc,NULL);

}
