c
c------ READ_FLT ------ readin dimensions from "lun"
c
      subroutine read_flt(lun,prm,n,ier)
      implicit none
      integer lun,n,ier,i
      real    prm(n)
      ier = 0
      call skip_comment(lun)
      read(lun,*,end=1000) (prm(i),i=1,n)
      return
 1000 ier=-1
      return
      end

      subroutine read_int(lun,prm,n,ier)
      implicit none
      integer lun,n,ier,i
      integer prm(n)
      ier = 0
      call skip_comment(lun)
      read(lun,*,end=1000) (prm(i),i=1,n)
      return
 1000 ier=-1
      return
      end
      

      subroutine read_flag(lun,flag,n,ier)
      implicit none
      integer lun, ier, n
      integer val(n),i
      logical flag(n) 
      ier  = 0
      call skip_comment(lun)
      call read_int(lun,val,n,ier)
      do i = 1,n 
         if (val(i).ne.0) then 
            flag(i) = .true.
         else 
            flag(i) = .false.
         endif
      enddo
      return
      end

      subroutine read_flt_list(lun,prm,n,ier)
      implicit none
      integer lun,n,ier
      real    prm(n)
      character*256 filename
      ier = 0
      call skip_comment(lun)
      read(lun,*,end=1000) filename
      open(unit=90,file=filename,status='old',err=999)
      call read_flt(90,prm,n,ier)
      close(90)
      return
 999  write(*,*) 'Cannot open file ',filename(1:len_trim(filename))
 1000 ier=-1
      return
      end

      subroutine read_int_list(lun,prm,n,ier)
      implicit none
      integer lun,n,ier
      integer prm(n)
      character*256 filename
      ier = 0
      call skip_comment(lun)
      read(lun,*,end=1000) filename
      open(unit=90,file=filename,status='old',err=999)
      call read_int(90,prm,n,ier)
      close(90)
      return
 999  write(*,*) 'Cannot open file ',filename(1:len_trim(filename))
 1000 ier=-1
      return
      end
      

c      subroutine read_map(lun,mapper,
      

      subroutine skip_comment(lun)
      integer lun
      character*1 c
      do while(.true.)
      read(lun,'(a1)',end=1000) c
      if (c.eq.'C' .or. c.eq.'c'
     &     .or. c.eq.'!' .or. c.eq.';' .or. c.eq.'#') cycle
      backspace lun
      exit
      enddo
      return
 1000 ier = -1
      return 
      end

c
c------ fcler ------    clear integer array
c
        subroutine fcler(arr,n)
        dimension arr(n)                !n must be larger than 0
        do i=1,n                        !otherwise, dimension error
           arr(i)=0.
        enddo
        return
        end

c
c------ icler ------    clear real array
c
        subroutine icler(mud,n)
        dimension mud(n)
        do i=1,n
           mud(i)=0
        enddo
        return
        end

      subroutine fill_flt(arr,n,val)
      implicit none
      integer i, n
      real arr(n), val
      do i=1,n
         arr(i) = val
      enddo
      return
      end

      subroutine fill_int(arr,n,val)
      implicit none
      integer i, n, arr(n), val
      do i=1,n
         arr(i) = val
      enddo
      return
      end

c
c print_line-----------------      
c
      subroutine print_line(len,line,lun)
c      
c print header and ender etc. (up to 3 lines)
c      
      implicit none
      character*1 line(1)
      integer*4 lun,len,j
      write(lun,600) (line(j),j=1,len)  
 600  format(3('  ',80A1/))
      return
      end
c       

