/* $Id:$ */
/**
 * @file   TArtSharedMemoryDataSource.hh
 * @date   Created : Mar 29, 2008 15:29:53 JST
 *   Last Modified : Dec 04, 2008 21:55:48 JST
 * @author RIPS Taro <rips@entrance.ripsnet>
 *  
 *  
 *    Copyright (C)2008
 */
#ifndef TARTSHAREDMEMORYDATASOURCE_H
#define TARTSHAREDMEMORYDATASOURCE_H

#include "TArtSharedMemory.h"
#include "TArtSemaphore.h"
#include "TArtDataSource.h"

#ifdef BABIRL
#define SHM_BUFF_SIZE 0x80000 // 256 kByte
#define ANSHMKEY 561000
#define ANSEMKEY 561001
#else 
#define SHM_BUFF_SIZE 0x4000 // 16 kByte
#define ANSHMKEY 17001
#define ANSEMKEY 18001
#endif
#ifdef __cplusplus
extern "C" {
#endif
   void setshmid_(int *shmid);
   void getshmid_(int *shmid);
#ifdef __cplusplus
}
#endif      

class TArtSharedMemoryDataSource  : public TArtDataSource {
public:
   ~TArtSharedMemoryDataSource();
   static TArtDataSource* Instance();
   int GetRunNumber(){return fRunNumber;}
   int  Open(const char* sourceName = 0);
   void Close();
   bool IsOpen();
   ArtBlockStat_t GetNextBlock();
   int Read(char *buf, const int &size, const int &offset = 0);
   void SetSharedMemoryID(int shmid); /// set shared memory id 
   int GetSharedMemoryID(); /// get shared memory id 
   virtual int Seek(long offset, int origin);
   virtual int IsPrepared();
   virtual int Wait();
protected:
   TArtSharedMemoryDataSource();
private:
   static TArtDataSource *fgInstance;
   TArtSharedMemory *fSharedMemory;
   TArtSemaphore    *fSemaphore;
   unsigned int      fNBlock;
   unsigned int      fMemoryPos;
   bool fIsOpen; /// status of data source
   int fRunNumber;
   int fSharedMemoryID;   /// for selection of shared memory 
   static const int kfMaxSharedMemoryID = 6; /// maxmum number of shared memories

};

#endif // end of #ifdef TARTSHAREDMEMORYDATASOURCE_H
