/*
 * @file TArtRawDataAllocator.h
 * @date  Created : 2008/10/28 20:41:23 JST<BR>
 *  Last Modified : 2008/10/30 23:45:17 JST
 *--------------------------------------------------------
 *    Comment : 
 *    
 *--------------------------------------------------------
 *    Copyright (C)2008 by Shinsuke OTA <ota@ribf.riken.jp>
 */
#ifndef TARTRAWDATAALLOCATOR_H
#define TARTRAWDATAALLOCATOR_H
#include <vector>
#include "TArtRawDataRef.h"
#include "TArtMap.h"
#define NWRAWDATA 10000
#define MAXCAT 64

#include <stdio.h>

extern "C" {
   extern struct {
      int rawdata[NWRAWDATA]; // rawdata[catid][detid][dataid]
      int rawheadpos[MAXCAT];   // rawhead[catid]
      int nhitdet[MAXCAT];   // nhitdet[catid]
      int hitdet[NWRAWDATA]; // hitdet[catid][detid]
      int nhitdata[NWRAWDATA]; // nhitdata[catid][detid]
      int hitheadpos[MAXCAT];
      int ndet[MAXCAT];
      int ndata[MAXCAT];
   } anarawdata_;
}

class TArtRawDataAllocator  {
private:
   int fNCatID;
   int *fRawData;
   int *fRawHeadPos;
   int *fHitDet;
   int *fNHitDet;
   int *fNHitData;
   int *fHitHeadPos;
   int *fNDet;
   int *fNData;
   int fNextRawHeadPos;
   int fNextHitHeadPos;
   TArtRawDataRef **fRawDataRefList[NWRAWDATA];
   TArtMap<TArtMap<TArtMap<int> > > fRawDataRefListIdx;
   int fRawDataRefListNextIdx;
   TArtRawDataAllocator();
   TArtRawDataAllocator(const TArtRawDataAllocator&rhs);
   TArtRawDataAllocator& operator=(const TArtRawDataAllocator&rhs);
public:
   ~TArtRawDataAllocator();
   static TArtRawDataAllocator* Instance();
   int Allocate();
   void Register(const int& catid, const int& detid, const int& type, TArtRawDataRef **ref);
   void Initialize();
   inline void ClearData();
};

inline void TArtRawDataAllocator::ClearData() 
{
  /* fortran */
  for (int i=0; i!=fNCatID; i++) {
    int *rawdata = fRawData+fRawHeadPos[i]-1;
    int &nhitdet = fNHitDet[i];
    int *hitdet  = fHitDet + fHitHeadPos[i]-1;
    int *nhitdata = fNHitData + fHitHeadPos[i]-1;
    int &ndata   = fNData[i];
    for (int j=0; j!=nhitdet; j++) {
      int id = hitdet[j]-1;
      nhitdata[id] = 0;
      for (int k=0; k!=ndata; k++) {
	rawdata[id*ndata+k] = TArtRawDataRef::kINVALID;
      }
      id = 0;
    }
    nhitdet = 0;
  }
  
  for(int l=0;l<10000;l++){
    anarawdata_.rawdata[l] = TArtRawDataRef::kINVALID;
  }
}
#endif // end of #ifdef TARTRAWDATAALLOCATOR_H
