/* $Id:$ */
/**
 * @file   TArtRIDF.h
 * @date   Created : Mar 30, 2008 03:30:27 JST
 *   Last Modified : Sep 09, 2008 10:43:48 JST
 * @author Taro RIPS <rips@branch04.ripsnet>
 *  
 *  
 *    Copyright (C)2008
 */
#ifndef TARTRIDF_H
#define TARTRIDF_H
#include "TArtDataFormat.h"
#include <stdio.h>
/** Header structure of ridf format 
 *
 */
typedef union {
   unsigned long long int BYTE; ///< 64bit header
   struct {
      unsigned long long int fSize:22; ///< class size
      unsigned long long int fClassID:6; ///< class id
      unsigned long long int fLayer:2; ///< layer id
      unsigned long long int fReserved:2; ///< reserved bit
      unsigned long long int fAddress:32; ///< address
      void Print() {
         printf("Ly   = %d\n",fLayer);
         printf("Cl   = %d\n",fClassID);
         printf("Size = %d\n",fSize);
         printf("Addr = %d\n",fAddress);
      }
   } BIT;
} ArtRidfHeader_t;
/** Analyze data format of ridf derived from TartDataFormat
 *
 */
class TArtRIDF  : public TArtDataFormat {
public:
   /**
    * default destructor 
    */ 
   virtual ~TArtRIDF();
   /**
    * Get instance of this class
    */
   static TArtDataFormat* Instance();
   /**
    * get next block
    * 
    * @param source data source
    * @return block status
    */
   virtual ArtBlockStat_t GetNextBlock(TArtDataSource* source);
   /**
    * get next event
    *
    * @param buf [out] event buffer
    * @param runbuf [out] character-base run number
    * @param rnum [out] run number
    * @param nw [out] size of event in word unit
    * @return event status
    */
   virtual ArtEventStat_t GetNextEvent(unsigned short* buf,
                                       unsigned short* runbuf, 
                                       unsigned short*rnum,
                                       int &nw);
   /**
    * find new segment
    *
    * @param evtdata [in] event data 
    * @param evtsize [in] size of event
<<<<<<< .mine
    * @param segid [out] segment id's
=======
    * @param segid [out] segid of each segment
>>>>>>> .r7
    * @param addr [out] offset of each segment
    * @param nw [out] size of each segment
    * @param nw [in] maximum number of segments
    */
   virtual void FindSegment(unsigned short *evtdata,
                            int *evtsize,
                            int *segid,
                            int *addr,
                            int *nw,
                            int *maxsegid);
protected:
   /**
    * protected default constructor
    */
   TArtRIDF();
private:
   /**
    * singleton instance
    */
   static TArtDataFormat* fgInstance;
};
#endif // end of #ifdef TARTRIDF_H
