/* $Id:$ */
/**
 * @file   TArtRDF.cc
 * @date   Created : Mar 28, 2008 15:28:47 JST
 *   Last Modified : Sep 26, 2008 13:52:08 JST
 * @author RIPS Taro <rips@entrance.ripsnet>
 *  
 *  
 *    Copyright (C)2008
 */
#include "TArtRDF.h"
#include <stdio.h>
#include <string.h>
const int TArtRDF::kBlockSize = 16 * 1024; // 16kByte
TArtDataFormat* TArtRDF::fgInstance = 0;
TArtRDF::TArtRDF()
{
   fBlockLen = kBlockSize;
}
TArtRDF::~TArtRDF()
{
}

TArtDataFormat* TArtRDF::Instance() 
{
   if (!fgInstance) {
      fgInstance = new TArtRDF;
   }
   return fgInstance;
}

ArtBlockStat_t TArtRDF::GetNextBlock(TArtDataSource* source) {
//   printf("<TArtRDF::GetNextBlock> data source at %p",source);
//   printf("<TArtRDF::GetNextBlock> read %d\n",fBlockLen);
   int len = source->Read((char*)fBlock,fBlockLen);
   //   printf("<TArtRDF::GetNextBlock> read length = %d\n",len);
   if (!len) return kEOF;
   if (len != fBlockLen) return kERRORBLOCK;
   fPointer = 4;
   return kNORMALBLOCK;
}

ArtEventStat_t TArtRDF::GetNextEvent(unsigned short* buf,
                                     unsigned short* runbuf,
                                     unsigned short* rnum,
                                     int &nw) 
{
   ArtEventStat_t eventStat = kERROREVENT;
   if (fBlock[0] != 0) {
      // comment block
      eventStat = kCOMMENT;
      runbuf[0] = fBlock[12];
      runbuf[1] = fBlock[13];
      return kCOMMENT;
   }   
   if ((fBlock[fPointer] & 0xf000) == 0x8000 &&
       (fBlock[fPointer+1]) ==  0x0001) {
      if (fBlock[fPointer-3] != 0) *rnum = fBlock[fPointer-3];
      unsigned int eventsize = (fBlock[fPointer] & 0x0fff);
      if (eventsize == 0 || (fPointer+eventsize) > kBlockSize/sizeof(short)) {
         eventStat = kERROREVENT;
      } else {
         eventStat = kNORMALEVENT;
	 nw = eventsize;
         memcpy(buf,&fBlock[fPointer],eventsize*sizeof(short));
	 //         printf("<TArtRDF::GetNextEvent> evtsize = %d\n",eventsize);
         fPointer += eventsize;
      }
   } else if (fBlock[fPointer]==0xffff && fBlock[fPointer+1]==0xffff) {
      eventStat = kEOB;
   } else if ((fBlock[fPointer]&0xf000)==0x8000 && 
              (fBlock[fPointer+1] == 0x7f00)) {
      eventStat = kEOB;
   } else {
      eventStat = kERROREVENT;
   }
   return eventStat;
}

   
void TArtRDF::FindSegment(unsigned short *evtdata,
                          int *evtsize,
                          int *segid,
                          int *addr,
                          int *nw,
                          int *maxsegid) 
{
   int nwtot, eid, iw, iseg;
   for (iseg=0;iseg<*maxsegid;iseg++) {
      addr[iseg] = -1;
      nw[iseg]   = 0;
   }
   iseg = 0;
   nwtot = evtdata[0] & 0x0fff;
   eid   = evtdata[2];
   iw = 3;
   while (iw < nwtot && iseg < *maxsegid) {
      segid[iseg] = evtdata[iw+1] - 1; // -1 for c-like array
      nw[iseg] = evtdata[iw] - 2;
      if (nw[iseg]<=0 || nw[iseg]>=nwtot) {
         nw[iseg] = 0;
         addr[iseg] = -2;
      } else {
         // +2 : exclude nw and iseg
         // +1 : convert for fortran addressing
         // totaly +3
         addr[iseg] = iw + 3;
      }
      iw += evtdata[iw];
      iseg++;
      if (iw > *evtsize) break;
      if (evtdata[iw]<=0) break;
   }
}
