/*
 * @file TArtParserFactory.cc
 * @date  Created : 2008/10/17 18:04:39 JST<BR>
 *  Last Modified : 2008/10/17 18:28:20 JST
 *--------------------------------------------------------
 *    Comment : 
 *    
 *--------------------------------------------------------
 *    Copyright (C)2008 by Shinsuke OTA<ota@ribf.riken.jp>
 */
#include "TArtParserFactory.h"
#include "TArtParserRDF.h"
#include "TArtParserRIDF.h"

#include "TArtCore.h"
TArtParser* TArtParserFactory::Create(TArtDataSource* source) {
   // check second word
   unsigned int header[2];
   const int size = sizeof(int)*2;
   if (!source->Read((char*)header,size,0)) return (TArtParser*)0;
   source->Seek(0,0);
   switch (header[1]) {
   case 0:
     TArtCore::Info("TArtParserFactory","Format = RDF");
     return TArtParserRDF::Instance();
      break;
   default:
     printf("header %08x %08x\n", header[1],header[2]);
     TArtCore::Info("TArtParserFactory","Format = RIDF");
     return TArtParserRIDF::Instance();
   }
}

TArtParserFactory::TArtParserFactory()
{
}
TArtParserFactory::~TArtParserFactory()
{
}
