/*
 * @file TArtMapConfig.h
 * @date  Created : 2008/10/30 05:29:36 JST<BR>
 *  Last Modified : 2008/10/30 21:46:14 JST
 *--------------------------------------------------------
 *    Comment : 
 *    
 *--------------------------------------------------------
 *    Copyright (C)2008 by Shinsuke OTA <ota@ribf.riken.jp>
 */
#ifndef TARTMAPCONFIG_H
#define TARTMAPCONFIG_H
#include "TArtMap.h"
#include "TArtRawDataAllocator.h"
class TArtMapConfig  {
public:
  typedef TArtMap<int> TArtMapChannels;
   typedef TArtMap<TArtMapChannels> TArtMapModules;
   typedef TArtMap<TArtMapModules> TArtMapDetectorTypes;
   typedef TArtMap<TArtMapDetectorTypes> TArtMapFocalPlanes;
   typedef TArtMap<TArtMapFocalPlanes> TArtMapDevices;
private:
   TArtMapDevices fRawDataRefListIdx;
   TArtRawDataRef *fRawDataRefList[NWRAWDATA];
   int fRawDataRefListNextIdx;
   bool fIsLoaded;

   TArtMapConfig();
   TArtMapConfig(const TArtMapConfig&rhs) {;}
   TArtMapConfig& operator=(const TArtMapConfig&rhs) {;}
public:
   ~TArtMapConfig();
   int GetRawDataVal(const int& idx) {
     return fRawDataRefList[idx]->GetVal();
   }
   TArtRawDataRef& GetRawDataRef(const int& idx) {
      return *fRawDataRefList[idx];
   }
   TArtMapModules& GetMapModules(const int& dev, const int& fp, const int& det) {
      return fRawDataRefListIdx[dev][fp][det];
   }
   void Initialize();
   static TArtMapConfig* Instance();
   void LoadConfig(const char* filename);
   bool IsLoaded();
};
#endif // end of #ifdef TARTMAPCONFIG_H
