/*
 * @file TArtMapConfig.cc
 * @date  Created : 2008/10/30 06:20:33 JST<BR>
 *  Last Modified : 2008/10/30 19:50:39 JST
 *--------------------------------------------------------
 *    Comment : 
 *    
 *--------------------------------------------------------
 *    Copyright (C)2008 by Shinsuke OTA <ota@ribf.riken.jp>
 */
#include "TArtMapConfig.h"
#include <iostream>
#include <fstream>
#include "TArtConfigFile.h"
#include "TArtCore.h"
#include "TArtRawDataAllocator.h"
#include "TArtRawDataRef.h"
TArtMapConfig::TArtMapConfig()
   : fRawDataRefListNextIdx(0), fIsLoaded(false)
{
}
TArtMapConfig::~TArtMapConfig()
{
   TArtCore::Info("TArtMapConfig","~TArtMapConfig");
}

void TArtMapConfig::Initialize()
{
   for (int i=0; i<fRawDataRefListNextIdx; i++) {
      if (fRawDataRefList[i]) delete fRawDataRefList[i];
      fRawDataRefList[i] = 0;
   }
   fRawDataRefListIdx.Clear();

   //fRawDataRefListNextIdx = 0;
   fRawDataRefListNextIdx = 0;

   fIsLoaded = false;
}

TArtMapConfig* TArtMapConfig::Instance()
{
   static TArtMapConfig instance;
   return &instance;
}

bool TArtMapConfig::IsLoaded()
{
   return fIsLoaded;
}

void TArtMapConfig::LoadConfig(const char* filename)
{
   TArtConfigFile configFile(filename);
   const char *str;
   const char *mapname = 0;
   int ndata;
   if (!fRawDataRefListNextIdx) fRawDataRefListNextIdx=1;
   TArtRawDataAllocator::Instance()->Initialize();
   while (1) {
      if (!(mapname = configFile.GetNextToken())) break;
      if (!configFile.GetNextTokenAsInt(ndata)) break;
      TArtCore::Info("TArtMapConfig","LoadConfig file = '%s'",mapname);
      TArtCore::Info("TArtMapConfig","LoadConfig ndata = %d",ndata);
      TArtConfigFile mapFile(mapname);
      while (1) {
         int catid, detid;
         const int nids = 5;
         int ids[nids];
         if (!mapFile.GetNextTokenAsInt(catid)) break;
         if (!mapFile.GetNextTokenAsInt(detid)) break;
         for (int i=0; i!=ndata; i++) {
            for (int j=0; j!=nids; j++) {
               if (!mapFile.GetNextTokenAsInt(ids[j])) break;
            }
	    // 2008/12/09 23:20 S.Takeuchi for check 
	    //            printf("%d,%d,%d,%d,%d\n",ids[0],ids[1],ids[2],ids[3],ids[4]);
	    //
	    if (fRawDataRefListIdx[ids[0]][ids[1]][ids[2]][ids[3]][ids[4]]) {
	      TArtCore::Info("TArtMapConfig","Collapse occurred!!!");
	      TArtCore::Info("TArtMapConfig"," Category = %d",catid);
	      TArtCore::Info("TArtMapConfig"," Detector = %d",detid);
	      TArtCore::Info("TArtMapConfig"," DataType = %d",i);
	      exit(0);
	    }
            fRawDataRefListIdx[ids[0]][ids[1]][ids[2]][ids[3]][ids[4]] = fRawDataRefListNextIdx;
            TArtRawDataAllocator::Instance()->Register(catid,detid,i,&fRawDataRefList[fRawDataRefListNextIdx]);
	    //	    TArtCore::Info("TArtMapConfig","catid = %02d, detid = %02d,nextidx = %02d\n",catid,detid,fRawDataRefListNextIdx);
            fRawDataRefListNextIdx++;
         }
      }
   }
   TArtCore::Info("TArtMapConfig","Total # of rawdata = %d\n",fRawDataRefListNextIdx-1);
   TArtRawDataAllocator::Instance()->Allocate();
   fIsLoaded = true;
   TArtCore::Info("TArtMapConfig","LoadConfig loaded");
   return;
}
