/*
 * @file TArtMap.h
 * @date  Created : 2008/10/30 01:41:20 JST<BR>
 *  Last Modified : 2008/10/30 22:52:01 JST
 *--------------------------------------------------------
 *    Comment : 
 *    
 *--------------------------------------------------------
 *    Copyright (C)2008 by Shinsuke OTA <ota@ribf.riken.jp>
 */
#ifndef TARTMAP_H
#define TARTMAP_H
#include <vector>
#include <algorithm>
#include "TArtCore.h"
class TArtRawDataRef;

template <class T>
class TArtMap  {
protected:
   std::vector<T> fMap;
public:
   TArtMap(int n=0) : fMap(std::vector<T>(n)){;}
   virtual ~TArtMap() {;}
   TArtMap(const TArtMap<T>&rhs) { Copy(rhs);}
   TArtMap& operator=(const TArtMap<T>&rhs) { Copy(rhs); return *this;}
   const std::vector<T>& GetMap() const { return fMap; }

   void Copy(const TArtMap<T>&rhs) {
      if (rhs.GetMap().size() > fMap.size()) {
         fMap.resize(rhs.GetMap().size());
      }
      std::copy(rhs.GetMap().begin(),rhs.GetMap().end(),fMap.begin());
   }

   void Clear() {
      fMap.clear();
   }

   
   inline T& operator[](const int& idx) {
     if (fMap.size() < idx + 1) fMap.resize(idx+1);
      return fMap[idx];
   }

};

/*
template <>
inline int& TArtMap<int>::operator[](const int& idx) {
  if (fMap.size() < idx + 1) fMap.resize(idx+1,-1);
  return fMap[idx];
}
*/

#endif // end of #ifdef TARTMAP_H
