/*
 * @file TArtDecoderV1290.cc
 * @date  Created : 2008/11/26 21:34:03 JST<BR>
 *  Last Modified : 2008/11/27 00:19:06 JST
 *--------------------------------------------------------
 *    Comment : 
 *    
 *--------------------------------------------------------
 *    Copyright (C)2008 by Shinsuke OTA <ota@ribf.riken.jp>
 */
#include "TArtDecoderV1290TQ.h"
#define V1290TQT0CH  0
#define V1290TQT0OFF 80000 // 2us in 25ps
#define V1290TQTSUB  1

TArtDecoderV1290TQ::TArtDecoderV1290TQ()
   : TArtDecoder(kID) {
}
TArtDecoderV1290TQ::~TArtDecoderV1290TQ()
{
}

TArtDecoder* TArtDecoderV1290TQ::Instance()
{
   static TArtDecoderV1290TQ instance;
   return &instance;
}

int TArtDecoderV1290TQ::Decode(unsigned char* &buf, const unsigned int& size,
                               TArtMapConfig::TArtMapModules &modules,
                               TArtMapConfig *config)
{
   unsigned int *evtdata = (unsigned int*) buf;
   unsigned int evtsize = size/sizeof(unsigned int);
   int i, ih, igeo, ich, icat ,idet, idata;
   int ghf, thf, bncid, evtid, edge;
   int evtflag = 0;
   ghf = thf = 0;
   int ttrigger = 0;
   TArtRawDataRef *data[2560];
   unsigned int rawt[2560];
   int nhit = 0, lnhit = 0;
   int tich[256], tnhit[256];

   for(i=0;i<256;i++){
     tnhit[i] = -1000;
   }
   
   for (int i=0; i<evtsize; i++) {
      ih = evtdata[i]&kHeaderMask;
      //printf("%d (ih=%08lx): 0x%08lx\n",i,ih,evtdata[i]);
      //printf("igeo = %d (0x%x)\n",igeo,igeo); 
      if (ih == kGlobalHeader) {
	nhit = 0;
         ghf = 1;
         igeo = (evtdata[i]&kMaskGeometry)>>kShiftGeometry;
	 //printf("V1290TQ [Global Header] : 0x%08x\n", evtdata[i]);
      } else if (ih == kTDCHeader) {
	//printf("V1290TQ [TDC    Header] : 0x%08x\n", evtdata[i]);
         if (ghf != 1) break;
         //thf = 1;
         bncid = (evtdata[i]&kMaskBunchID)>>kShiftBunchID;
         evtid = (evtdata[i]&kMaskEventCounter)>>kShiftEventCounter;
      } else if (ih == kTDCMeasurement) {
	//printf("V1290TQ [TDC Measureme] : 0x%08x\n", evtdata[i]);
         //if (thf != 1) continue;
         ich = (evtdata[i]&kMaskChannel) >> kShiftChannel;
         edge = (evtdata[i]&kMaskEdgeType) >> kShiftEdgeType;

	 if (edge==1) ich+=128;
	 //	 printf("igeo=%d, ich=%d, edge=%d\n", igeo,ich,edge);
         
	 if (ich==V1290TQT0CH) {
	   ttrigger = (evtdata[i]&kMaskMeasure) >> kShiftMeasure;
	   continue;
	 }
	 /* Check first hit */
	 
	 if (modules[igeo][ich]){
	   if(config->GetRawDataVal(modules[igeo][ich]) == 
	      TArtRawDataRef::kINVALID){
	     data[nhit] = &config->GetRawDataRef(modules[igeo][ich]);
	     rawt[nhit] = (evtdata[i]&kMaskMeasure) >> kShiftMeasure;
	     tich[nhit] = ich;
	     tnhit[ich] = nhit;
	     nhit++;

	     // printf("rawt[%d] = %d, cpmfig=%d\n",nhit,rawt[nhit],(evtdata[i]&kMaskMeasure) >> kShiftMeasure);
	   } 
	 }
      } else if (ih == kTDCTrailer) {
	//printf("V1290TQ [TDC Trailer  ] : 0x%08x\n", evtdata[i]);
      } else if (ih == kTDCError) {
	//printf("V1290TQ [TDC Error    ] : 0x%08x\n", evtdata[i]);
      } else if (ih == kGlobalTrailer) {
	for (int j = 0; j!=nhit;j++) {
	  if (data[j]->GetVal() == TArtRawDataRef::kINVALID) {
	    if(tich[j] < 128){
#ifdef V1290TQTSUB
	      *data[j] = -(ttrigger  - rawt[j]) + V1290TQT0OFF;
#else
	      *data[j] = rawt[j]%1024;
#endif
	    }else{
	      lnhit = tnhit[tich[j]-128];
	      if(lnhit >= 0){
		*data[j] = rawt[j] - rawt[lnhit];
	      }else{
		*data[j] = -1000000;
	      }
	    }
	    //printf("rawt[%d] = %d, ttrigger=%d\n",j,rawt[j],ttrigger);
	  }
	}
	ghf = 0;
      }
   }
   return 0;
}
