/*
 * @file TArtDecoderV1190.cc
 * @date  Created : 2008/11/26 21:34:03 JST<BR>
 *  Last Modified : 2008/11/27 00:19:06 JST
 *--------------------------------------------------------
 *    Comment : 
 *    
 *--------------------------------------------------------
 *    Copyright (C)2008 by Shinsuke OTA <ota@ribf.riken.jp>
 */
#include "TArtDecoderV1190TQ.h"
#include "V1190INL.h"
#define V1190TQT0CH  0
#define V1190TQT0OFF 20000 // 2us in 100ps
#define V1190TQTSUB  1
#define V1190TQINLCOL 1

TArtDecoderV1190TQ::TArtDecoderV1190TQ()
   : TArtDecoder(kID) {
}
TArtDecoderV1190TQ::~TArtDecoderV1190TQ()
{
}

TArtDecoder* TArtDecoderV1190TQ::Instance()
{
   static TArtDecoderV1190TQ instance;
   return &instance;
}

int TArtDecoderV1190TQ::Decode(unsigned char* &buf, const unsigned int& size,
                               TArtMapConfig::TArtMapModules &modules,
                               TArtMapConfig *config)
{
   unsigned int *evtdata = (unsigned int*) buf;
   unsigned int evtsize = size/sizeof(unsigned int);
   int i, ih, igeo, ich, icat ,idet, idata;
   int ghf, thf, bncid, evtid, edge;
   int evtflag = 0;
   ghf = thf = 0;
   int ttrigger = 0;
   TArtRawDataRef *data[2560];
   unsigned int rawt[2560];
   int nhit = 0, lnhit = 0;
   int tich[256], tnhit[256];
#ifdef V1190TQINLCOL
	   int it, ttch;
	   float r, rr;
#endif

   for(i=0;i<256;i++){
     tnhit[i] = -1000;
   }
   
   for (int i=0; i<evtsize; i++) {
      ih = evtdata[i]&kHeaderMask;
      //printf("%d (ih=%08lx): 0x%08lx\n",i,ih,evtdata[i]);
      //printf("igeo = %d (0x%x)\n",igeo,igeo); 
      if (ih == kGlobalHeader) {
	nhit = 0;
         ghf = 1;
         igeo = (evtdata[i]&kMaskGeometry)>>kShiftGeometry;
	 //printf("V1190TQ [Global Header] : 0x%08x\n", evtdata[i]);
      } else if (ih == kTDCHeader) {
	//printf("V1190TQ [TDC    Header] : 0x%08x\n", evtdata[i]);
         if (ghf != 1) break;
         //thf = 1;
         bncid = (evtdata[i]&kMaskBunchID)>>kShiftBunchID;
         evtid = (evtdata[i]&kMaskEventCounter)>>kShiftEventCounter;
      } else if (ih == kTDCMeasurement) {
	//printf("V1190TQ [TDC Measureme] : 0x%08x\n", evtdata[i]);
         //if (thf != 1) continue;
         ich = (evtdata[i]&kMaskChannel) >> kShiftChannel;
         edge = (evtdata[i]&kMaskEdgeType) >> kShiftEdgeType;

	 if (edge==1) ich+=128;
	 //printf("igeo=%d, ich=%d, edge=%d\n", igeo,ich,edge);
         
	 if (ich==V1190TQT0CH) {
	   ttrigger = (evtdata[i]&kMaskMeasure) >> kShiftMeasure;

#ifdef V1190TQINLCOL
	   it = ttrigger%256;
	   if(ich > 128){
	     ttch = ich - 128;
	   }else{
	     ttch = ich;
	   }
	   r = (float)random()/((float)(RAND_MAX)+(float)(1));
	   ttrigger = ttrigger/256 * 256;
	   rr = (float)ttrigger + (float)inl[ttch][it]
	     + (float)(inl[ttch][it+1] - inl[ttch][it])*r;
	   ttrigger = (unsigned int)rr;
#endif

	   //continue;
	 }
	 /* Check first hit */
	 
	 if (modules[igeo][ich]){
	   if(config->GetRawDataVal(modules[igeo][ich]) == 
	      TArtRawDataRef::kINVALID){
	     data[nhit] = &config->GetRawDataRef(modules[igeo][ich]);
	     rawt[nhit] = (evtdata[i]&kMaskMeasure) >> kShiftMeasure;
	     tich[nhit] = ich;
	     tnhit[ich] = nhit;

#ifdef V1190TQINLCOL
	     it = rawt[nhit]%256;
	     if(ich > 128){
	       ttch = ich - 128;
	     }else{
	       ttch = ich;
	     }
	     r = (float)random()/((float)(RAND_MAX)+(float)(1));
	     rawt[nhit] = rawt[nhit]/256 * 256;
	     rr = (float)rawt[nhit] + (float)inl[ttch][it]
	       + (float)(inl[ttch][it+1] - inl[ttch][it])*r;
	     rawt[nhit] = (unsigned int)rr;
#endif
	     nhit++;
	   } 
	 }
      } else if (ih == kTDCTrailer) {
	//printf("V1190TQ [TDC Trailer  ] : 0x%08x\n", evtdata[i]);
      } else if (ih == kTDCError) {
	//printf("V1190TQ [TDC Error    ] : 0x%08x\n", evtdata[i]);
      } else if (ih == kGlobalTrailer) {
	for (int j = 0; j!=nhit;j++) {
	  if (data[j]->GetVal() == TArtRawDataRef::kINVALID) {
	    if(tich[j] < 128){
#ifdef V1190TQTSUB
	      *data[j] = -(ttrigger  - rawt[j]) + V1190TQT0OFF;
#else
	      *data[j] = rawt[j]%256;
#endif
	    }else{
	      lnhit = tnhit[tich[j]-128];
	      if(lnhit >= 0){
		*data[j] = rawt[j] - rawt[lnhit];
	      }else{
		*data[j] = -1000000;
	      }
	    }
	  }
	}
	ghf = 0;
      }
   }
   return 0;
}
