/*
 * @file TArtDecoderFixed48.cc
 * @date  Created : 2008/10/29 48:08:53 JST<BR>
 *  Last Modified : 2008/10/30 23:59:31 JST
 *--------------------------------------------------------
 *    Comment : 
 *    
 *--------------------------------------------------------
 *    Copyright (C)2008 by Shinsuke OTA <ota@ribf.riken.jp>
 */
#include "TArtDecoderFixed48.h"
#include "TArtDecoderFactory.h"
#include "TArtCore.h"

TArtDecoderFixed48::TArtDecoderFixed48()
   : TArtDecoder(kID) {
}

TArtDecoderFixed48::~TArtDecoderFixed48()
{
}

TArtDecoder* TArtDecoderFixed48::Instance()
{
   static TArtDecoderFixed48 instance;
   return &instance;
}

int TArtDecoderFixed48::Decode(unsigned char* &buf, const unsigned int& size,
                               TArtMapConfig::TArtMapModules &modules,
                               TArtMapConfig *config)
{
  unsigned long long int *evtdata = (unsigned long long int*) buf;
  unsigned int evtsize = size/sizeof(unsigned long long int);

   for (int i=0; i<evtsize; i++) {
     config->GetRawDataRef(modules[0][i]) = evtdata[i];
     // This case, data will be masked lower 32 bits
   }
   return 0;
}
