/*
 * @file TArtDecoderFactory.cc
 * @date  Created : 2008/10/29 15:21:56 JST<BR>
 *  Last Modified : 2008/11/27 00:53:15 JST
 *--------------------------------------------------------
 *    Comment : 
 *    
 *--------------------------------------------------------
 *    Copyright (C)2008 by Shinsuke OTA <ota@ribf.riken.jp>
 */
#include "TArtDecoderFactory.h"
#include "TArtCore.h"
#include "TArtDecoderFixed16.h"
#include "TArtDecoderFixed24.h"
#include "TArtDecoderFixed48.h"
#include "TArtDecoderP716X.h"
#include "TArtDecoderAD413A.h"
#include "TArtDecoderL3377d.h"
#include "TArtDecoderV7XX.h"
#include "TArtDecoderV1190.h"
#include "TArtDecoderV1190C.h"
#include "TArtDecoderV1190TQ.h"
#include "TArtDecoderV1290.h"
#include "TArtDecoderV1290TQ.h"
#include "TArtDecoderV767.h"
#include "TArtDecoderV550.h"
#include "TArtDecoderA3100.h"
#include "TArtDecoderMADC32.h"
#include "TArtDecoderGANIL.h"
#include "TArtDecoderAP.h"
#include "TArtDecoderLUPO.h"
#include "TArtDecoderTimeStamp.h"

TArtDecoderFactory::TArtDecoderFactory()
{
//   fDecoder = new TArtDecoder*[kNDecoder];
   Register();
}
TArtDecoderFactory::~TArtDecoderFactory()
{
   for (int i=0; i<kNDecoder; i++) {
      fDecoder[i] = 0;
   }
}

void TArtDecoderFactory::Register()
{
   Register(TArtDecoderFixed16::Instance());
   Register(TArtDecoderFixed24::Instance());
   Register(TArtDecoderFixed48::Instance());
   Register(TArtDecoderAD413A::Instance());
   Register(TArtDecoderL3377d::Instance());
   Register(TArtDecoderP716X::Instance());
   Register(TArtDecoderV7XX::Instance());
   Register(TArtDecoderV1190::Instance());
   Register(TArtDecoderV1190C::Instance());
   Register(TArtDecoderV1190TQ::Instance());
   Register(TArtDecoderV1290::Instance());
   Register(TArtDecoderV1290TQ::Instance());
   Register(TArtDecoderV767::Instance());
   Register(TArtDecoderV550::Instance());
   Register(TArtDecoderA3100::Instance());
   Register(TArtDecoderMADC32::Instance());
   Register(TArtDecoderAP::Instance());
   Register(TArtDecoderLUPO::Instance());
   Register(TArtDecoderTimeStamp::Instance());
   Register(TArtDecoderGANIL::Instance());
}


TArtDecoderFactory* TArtDecoderFactory::Instance()
{
   static TArtDecoderFactory instance;
   return &instance;
}

TArtDecoder *TArtDecoderFactory::GetDecoder(const int& id)
{
   return fDecoder[id];
}


void TArtDecoderFactory::Register(TArtDecoder *decoder)
{
   int id = decoder->GetID();
   fDecoder[id] = decoder;
}

   
