/* $Id:$ */
/**
 * @file   TArtDataSource.h
 * @date   Created : Mar 29, 2008 12:29:43 JST<BR>
 *   Last Modified : Dec 04, 2008 21:57:42 JST
 * @author Shinsuke OTA <ota@ribf.riken.jp>
 *  
 *  
 *    Copyright (C)2008
 */
#ifndef TARTDATASOURCE_H
#define TARTDATASOURCE_H
class TArtDataFormat;

/** 
 * \enum ArtBlockType_t
 * \brief enumuration for the block type 
 */
typedef enum { 
   kNormal, ///< normal block
   kEnd,  ///< reach at end of block
   kComment, ///< comment block
   kError ///< error block
} ArtBlockType_t;

/** enumuration for the status of extraction for data block */
typedef enum {
   kNORMALBLOCK, ///< good block
   kWAIT, ///< wating for new block
   kRUNSTOP, ///< run is stopped (online mode)
   kEOF, ///< reach at end of file (offline mode)
   kERRORBLOCK ///< fatal error occurred
} ArtBlockStat_t;
/** enumeration for the status of extraction for event data */
typedef enum {
   kNORMALEVENT,  ///< good event
   kEOB, ///< reach at end of block
   kCOMMENT, ///< comment 
   kERROREVENT ///< fatal error occurred
} ArtEventStat_t;
/** enumeration for the file status */
enum ArtFileStat_t {
   kEXIST = 0, ///< file exists
   kNOTEXIST ///< file does not exists (whichever error or not)
} ;

/** 
 * This class is a abstract base class for dealing with a data source.
 *
 * Several methods such as TArtDataSource::Open,
 * TArtDataSource::Close, TArtDataSource::Read and
 * TArtDataSource::GetNextBlock should be implemented in each derived
 * class.
 * The derived class itself might be a singleton.
 */
class TArtDataSource {
public:
   static const int kMaxBufferSize;
   virtual ~TArtDataSource();
   virtual int Open(const char* sourceName = 0) = 0;
   virtual int GetRunNumber() = 0;
   virtual void Close() = 0;
   virtual int Read(char *buf,const int& size, const int &offset = 0) = 0;
   virtual int Seek(long offset, int origin) = 0;
   // mainly for shared memory data source to check data exists or not
   // and lock semaphore
   virtual int IsPrepared() { return 1; };
   // mainly for shared memory data source to unlock semaphore
   virtual int Wait() {; }
//   virtual ArtBlockStat_t GetNextBlock() = 0;
//   virtual ArtEventStat_t GetNextEvent(unsigned short* buf,
//                                       unsigned short* runbuf,
//                                       unsigned short*rnum,
//                                       int &nw);
//   TArtDataFormat *GetDataFormat() { return fFormat; }
   int GetSourceTyepID();
protected:
   TArtDataSource(int id = 0);
   TArtDataFormat *fFormat;
   int fID;
   ArtBlockStat_t  fBlockStatus;
   ArtEventStat_t  fEventStatus;
   ArtFileStat_t   fFileStatus;
private:
   
};
#endif // end of #ifdef TARTDATASOURCE_H
