/* $Id:$ */
/**
 * @file   TArtDataFormat.h
 * @date   Created : Mar 28, 2008 15:28:02 JST<BR>
 *   Last Modified : Sep 09, 2008 10:42:56 JST
 * @author Shinsuke OTA <ota@ribf.riken.jp>
 *  
 *  
 *    Copyright (C)2008
 */
#ifndef TARTDATAFORMAT_H
#define TARTDATAFORMAT_H
#include "TArtDataSource.h"
/** Base class for dealing with corresponding data format.
 *
 */
class TArtDataFormat  {
protected:
   TArtDataFormat();
   unsigned short *fBlock; ///< a buffer of a block, which will be
                           ///allocated in the default constructor.
   unsigned int    fBlockLen; ///< block length 
   ArtBlockType_t  fBlockType; ///< block type
   unsigned int    fPointer; ///< offset of the current position to the buffer 
   
public:
   /** 
    *
    */
   virtual void Delete();
   /** Get next block from the source. 
    *
    * The head position, the length and the type of the
    *  new block should be assigned to fBlock, fBlockLen, and
    *  fBlockType, respectively, in this method.
    *
    * @param source data source 
    * @return status of block data
    */
   virtual ArtBlockStat_t GetNextBlock(TArtDataSource* source) = 0;

   /** 
    * Get next event data.
    *
    * The information of the next event data will be returned to 
    * arguments.
    *  
    * @param buf [out] the pointer to the new event 
    * @param runbuf [out] the pointer to the run number in comment block
    * @param rnum [out] the pointer to the run number (used for dump data)
    * @param nw [out] the number of words in the new event
    *
    * @return status of event data
    */
   virtual ArtEventStat_t GetNextEvent(unsigned short* buf,
                                       unsigned short* runbuf,
                                       unsigned short*rnum,
                                       int &nw) = 0;

   /**
    * Search find segmentids in the event data. 
    *
    * @param evtdata [in] the event data to be seached 
    * @param evtsize [in] the size of the event data
    * @param segid [out] an array of segment id's
    * @param addr [out] an array with the length of maxsegid
    *             where the offset of each segment is saved
    * @param nw [out] an array with the length of maxsegid
    *             where the number of words of each segment is saved
    * @param maxsegid [in] the length of the array 
    */
   virtual void FindSegment(unsigned short *evtdata,
                            int *evtsize,
                            int *segid,
                            int *addr,
                            int *nw,
                            int *maxsegid) = 0;

   /**
    * Default destructor.
    */
   virtual ~TArtDataFormat();

   /**
    * The size of the buffer allocated to fBlock.
    */
   static const unsigned int kMaxBlockLen;
};
#endif // end of #ifdef TARTDATAFORMAT_H
